/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.artifact;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.DirectoryResourceLocator;
import org.mule.module.launcher.FineGrainedControlClassLoader;
import org.mule.module.launcher.LocalResourceLocator;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.ShutdownListener;

public abstract class AbstractArtifactClassLoader
extends FineGrainedControlClassLoader
implements ArtifactClassLoader {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private LocalResourceLocator localResourceLocator;

    public AbstractArtifactClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, Collections.emptySet());
    }

    public AbstractArtifactClassLoader(URL[] urls, ClassLoader parent, Set<String> overrides) {
        super(urls, parent, overrides);
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownListeners.add(listener);
    }

    @Override
    public void dispose() {
        for (ShutdownListener listener : this.shutdownListeners) {
            try {
                listener.execute();
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
        super.dispose();
    }

    @Override
    public URL findLocalResource(String resourceName) {
        URL resource = this.getLocalResourceLocator().findLocalResource(resourceName);
        if (resource == null && this.getParent() instanceof LocalResourceLocator) {
            resource = ((LocalResourceLocator)((Object)this.getParent())).findLocalResource(resourceName);
        }
        return resource;
    }

    private LocalResourceLocator getLocalResourceLocator() {
        if (this.localResourceLocator == null) {
            this.localResourceLocator = new DirectoryResourceLocator(this.getLocalResourceLocations());
        }
        return this.localResourceLocator;
    }

    protected abstract String[] getLocalResourceLocations();
}

