/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.log4j2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.status.StatusLogger;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.DirectoryResourceLocator;
import org.mule.module.launcher.LocalResourceLocator;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.ShutdownListener;
import org.mule.module.launcher.log4j2.MuleLoggerContext;
import org.mule.module.reboot.MuleContainerBootstrapUtils;

final class ArtifactAwareContextSelector
implements ContextSelector {
    private static final int NO_CCL_CLASSLOADER = 0;
    private static final StatusLogger logger = StatusLogger.getLogger();
    private LoggerContextCache cache = new LoggerContextCache();

    ArtifactAwareContextSelector() {
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return this.getContext(fqcn, loader, currentContext, null);
    }

    public LoggerContext getContext(String fqcn, ClassLoader classLoader, boolean currentContext, URI configLocation) {
        return this.cache.getLoggerContext(this.resolveClassLoader(classLoader));
    }

    public List<LoggerContext> getLoggerContexts() {
        return this.cache.getAllLoggerContexts();
    }

    public void removeContext(LoggerContext context) {
        this.cache.remove(context);
    }

    private ClassLoader resolveClassLoader(ClassLoader classLoader) {
        return classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
    }

    private void destroyLoggersFor(ClassLoader classLoader) {
        this.cache.remove(classLoader);
    }

    private NewContextParameters resolveContextParameters(ClassLoader classLoader) {
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)((Object)classLoader);
            return new NewContextParameters(this.getArtifactLoggingConfig(artifactClassLoader), artifactClassLoader.getArtifactName());
        }
        if (MuleContainerBootstrapUtils.getMuleConfDir() != null) {
            return new NewContextParameters(this.getLogConfig(new DirectoryResourceLocator(MuleContainerBootstrapUtils.getMuleConfDir().getAbsolutePath())), classLoader.toString());
        }
        return null;
    }

    private LoggerContext buildContext(final ClassLoader classLoader) {
        NewContextParameters parameters = this.resolveContextParameters(classLoader);
        if (parameters == null) {
            return this.getDefaultContext();
        }
        MuleLoggerContext loggerContext = new MuleLoggerContext(parameters.contextName, parameters.loggerConfigFile, classLoader, this, this.isStandalone());
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)((Object)classLoader);
            artifactClassLoader.addShutdownListener(new ShutdownListener(){

                @Override
                public void execute() {
                    ArtifactAwareContextSelector.this.destroyLoggersFor(classLoader);
                }
            });
        }
        return loggerContext;
    }

    private URI getArtifactLoggingConfig(ArtifactClassLoader muleCL) {
        URI appLogConfig = this.getLogConfig(muleCL);
        if (appLogConfig != null && logger.isInfoEnabled()) {
            logger.info("Found logging config for application '{}' at '{}'", new Object[]{muleCL.getArtifactName(), appLogConfig});
        }
        return appLogConfig;
    }

    private URI getLogConfig(LocalResourceLocator localResourceLocator) {
        URL appLogConfig = localResourceLocator.findLocalResource("log4j2-test.xml");
        if (appLogConfig == null) {
            appLogConfig = localResourceLocator.findLocalResource("log4j2.xml");
        }
        if (appLogConfig == null) {
            File defaultConfigFile = new File(MuleContainerBootstrapUtils.getMuleHome(), "conf");
            defaultConfigFile = new File(defaultConfigFile, "log4j2.xml");
            try {
                appLogConfig = defaultConfigFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not locate log config in MULE_HOME"), (Throwable)e);
            }
        }
        try {
            return appLogConfig.toURI();
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)("Could not read log file " + appLogConfig)), (Throwable)e);
        }
    }

    private LoggerContext getDefaultContext() {
        return new MuleLoggerContext("Default", this, this.isStandalone());
    }

    private boolean isStandalone() {
        return MuleContainerBootstrapUtils.getMuleConfDir() != null;
    }

    private class NewContextParameters {
        private final URI loggerConfigFile;
        private final String contextName;

        private NewContextParameters(URI loggerConfigFile, String contextName) {
            this.loggerConfigFile = loggerConfigFile;
            this.contextName = contextName;
        }
    }

    private class LoggerContextCache {
        private Cache<Integer, LoggerContext> contexts;

        private LoggerContextCache() {
            this.contexts = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<Integer, LoggerContext>(){

                public void onRemoval(RemovalNotification<Integer, LoggerContext> notification) {
                    LoggerContext context = (LoggerContext)notification.getValue();
                    if (context != null && !context.isStopping() && !context.isStopped()) {
                        context.stop();
                    }
                }
            }).build();
        }

        private LoggerContext getLoggerContext(final ClassLoader classLoader) {
            LoggerContext ctx;
            try {
                ctx = (LoggerContext)this.contexts.get((Object)this.computeKey(classLoader), (Callable)new Callable<LoggerContext>(){

                    @Override
                    public LoggerContext call() throws Exception {
                        return ArtifactAwareContextSelector.this.buildContext(classLoader);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not init logger context "), (Throwable)e);
            }
            if (ctx.getState() == LifeCycle.State.INITIALIZED) {
                ctx.start();
            }
            return ctx;
        }

        private void remove(ClassLoader classLoader) {
            this.contexts.invalidate((Object)this.computeKey(classLoader));
        }

        private void remove(LoggerContext context) {
            for (Map.Entry entry : this.contexts.asMap().entrySet()) {
                if (entry.getValue() != context) continue;
                this.contexts.invalidate(entry.getKey());
                return;
            }
        }

        private int computeKey(ClassLoader classLoader) {
            return classLoader == null ? 0 : classLoader.hashCode();
        }

        private List<LoggerContext> getAllLoggerContexts() {
            return ImmutableList.copyOf(this.contexts.asMap().values());
        }
    }
}

