/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.type.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.type.Converter;
import org.jbpm.pvm.internal.type.Variable;

public class DateToStringConverter
implements Converter {
    private static final long serialVersionUID = 1L;
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    public Object convert(Object o, ScopeInstanceImpl scopeInstance, Variable variable) {
        return this.dateFormat.format((Date)o);
    }

    public Object revert(Object o, ScopeInstanceImpl scopeInstance, Variable variable) {
        try {
            return this.dateFormat.parseObject((String)o);
        }
        catch (ParseException e) {
            throw new JbpmException("invalid date format in date variable: " + o, (Throwable)e);
        }
    }

    public boolean supports(Object value, ScopeInstanceImpl scopeInstance, Variable variable) {
        return value != null && value instanceof Date;
    }

    public void setFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }
}

