/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import com.google.common.base.Charsets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.SerializationException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.security.Authentication;
import org.mule.api.security.Credentials;
import org.mule.api.security.SecurityContext;
import org.mule.security.DefaultMuleAuthentication;
import org.mule.security.DefaultSecurityContextFactory;
import org.mule.security.MuleCredentials;
import org.mule.session.DefaultMuleSession;
import org.mule.session.LegacySessionHandler;
import org.mule.session.SerializeAndEncodeSessionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MuleSessionHandlerTestCase
extends AbstractMuleTestCase {
    private static String originalEncoding;
    private MuleContext muleContext;

    @Before
    public void setUp() throws Exception {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration configuration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)configuration.getDefaultEncoding()).thenReturn((Object)Charsets.UTF_8.name());
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)this.muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
    }

    @BeforeClass
    public static void setUpEncoding() {
        originalEncoding = System.getProperty("mule.encoding");
        System.setProperty("mule.encoding", "UTF-8");
    }

    @AfterClass
    public static void restoreEncoding() {
        if (originalEncoding == null) {
            System.clearProperty("mule.encoding");
        } else {
            System.setProperty("mule.encoding", originalEncoding);
        }
    }

    @Test
    public void testSessionProperties() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", this.muleContext);
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        DefaultMuleSession session = new DefaultMuleSession();
        String string = "bar";
        session.setProperty("fooString", (Serializable)((Object)string));
        Date date = new Date(0L);
        session.setProperty("fooDate", (Serializable)date);
        List<String> list = this.createList();
        session.setProperty("fooList", list);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        Object s = message.removeProperty("MULE_SESSION");
        message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)message);
        Object obj = session.getProperty("fooString");
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((Object)string, (Object)obj);
        obj = session.getProperty("fooDate");
        Assert.assertTrue((String)("Object should be a Date but is " + obj.getClass().getName()), (boolean)(obj instanceof Date));
        Assert.assertEquals((Object)date, (Object)obj);
        obj = session.getProperty("fooList");
        Assert.assertTrue((String)("Object should be a List but is " + obj.getClass().getName()), (boolean)(obj instanceof List));
        Assert.assertEquals(list, (Object)obj);
    }

    @Test
    public void testNonSerializableSessionProperties() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", this.muleContext);
        DefaultMuleSession session = new DefaultMuleSession();
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        NotSerializableClass clazz = new NotSerializableClass();
        session.setProperty("foo", (Object)clazz);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        Object s = message.removeProperty("MULE_SESSION");
        message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)message);
        Assert.assertNull((Object)session.getProperty("foo"));
    }

    @Test
    public void testBackwardsCompatibility() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", this.muleContext);
        LegacySessionHandler legacyHandler = new LegacySessionHandler();
        DefaultMuleSession session = new DefaultMuleSession();
        String string = "bar";
        session.setProperty("fooString", (Serializable)((Object)string));
        Date date = new Date(0L);
        session.setProperty("fooDate", (Serializable)date);
        List<String> list = this.createList();
        session.setProperty("fooList", list);
        legacyHandler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        try {
            session = new SerializeAndEncodeSessionHandler().retrieveSessionInfoFromMessage((MuleMessage)message);
        }
        catch (SerializationException e) {
            // empty catch block
        }
        session = legacyHandler.retrieveSessionInfoFromMessage((MuleMessage)message);
    }

    @Test
    public void testSessionPropertiesLegacyFormat() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", this.muleContext);
        LegacySessionHandler handler = new LegacySessionHandler();
        DefaultMuleSession session = new DefaultMuleSession();
        String string = "bar";
        session.setProperty("fooString", (Serializable)((Object)string));
        Date date = new Date(0L);
        session.setProperty("fooDate", (Serializable)date);
        List<String> list = this.createList();
        session.setProperty("fooList", list);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        Object s = message.removeProperty("MULE_SESSION");
        message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)message);
        Object obj = session.getProperty("fooString");
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((Object)string, (Object)obj);
        obj = session.getProperty("fooDate");
        Assert.assertTrue((boolean)(obj instanceof String));
        obj = session.getProperty("fooList");
        Assert.assertTrue((boolean)(obj instanceof String));
    }

    @Test
    public void testSecurityContext() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", this.muleContext);
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        DefaultMuleSession session = new DefaultMuleSession();
        MuleCredentials credentials = new MuleCredentials("joe", "secret".toCharArray());
        SecurityContext sc = new DefaultSecurityContextFactory().create((Authentication)new DefaultMuleAuthentication((Credentials)credentials));
        session.setSecurityContext(sc);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        Object s = message.removeProperty("MULE_SESSION");
        message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)message);
        sc = session.getSecurityContext();
        Assert.assertEquals((Object)"joe", (Object)sc.getAuthentication().getPrincipal());
    }

    @Test
    public void testNotSerializableSecurityContext() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", this.muleContext);
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        DefaultMuleSession session = new DefaultMuleSession();
        session.setSecurityContext((SecurityContext)new NotSerializableSecurityContext());
        try {
            handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
            Assert.fail((String)"Should throw a SerializationException");
        }
        catch (SerializationException e) {
            // empty catch block
        }
    }

    private List<String> createList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("bar1");
        list.add("bar2");
        return list;
    }

    private class NotSerializableSecurityContext
    implements SecurityContext {
        public void setAuthentication(Authentication authentication) {
        }

        public Authentication getAuthentication() {
            return null;
        }
    }

    private class NotSerializableClass {
    }
}

