/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message.processing;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.execution.AsyncResponseFlowProcessingPhase;
import org.mule.execution.AsyncResponseFlowProcessingPhaseTemplate;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.PhaseResultNotifier;
import org.mule.execution.ResponseCompletionCallback;
import org.mule.execution.ResponseDispatchException;
import org.mule.execution.ValidationPhase;
import org.mule.message.processing.PhaseSupportTestHelper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class AsyncResponseFlowProcessingPhaseTestCase
extends AbstractMuleTestCase {
    private AsyncResponseFlowProcessingPhase phase = new AsyncResponseFlowProcessingPhase();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private AsyncResponseFlowProcessingPhaseTemplate mockTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PhaseResultNotifier mockNotifier;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResponseDispatchException mockResponseDispatchException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleException mockException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DefaultMuleEvent mockMuleEvent;

    @Before
    public void configureExpectedBehaviour() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentSuccessfully();
                return null;
            }
        }).when((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)Matchers.any(MessagingException.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentSuccessfully();
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockTemplate.getMuleEvent()).thenReturn((Object)this.mockMuleEvent);
    }

    @Test
    public void supportedTemplates() {
        new PhaseSupportTestHelper<AsyncResponseFlowProcessingPhaseTemplate>(AsyncResponseFlowProcessingPhaseTemplate.class).testSupportTemplates((MessageProcessPhase)this.phase);
    }

    @Test
    public void order() {
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)new ValidationPhase()), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)Mockito.mock(MessageProcessPhase.class)), (Matcher)Is.is((Object)0));
    }

    @Test
    public void runPhaseWithMessagingExceptionThrown() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)true);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockMessagingException).when((Object)this.mockTemplate)).routeEvent((MuleEvent)Matchers.any(MuleEvent.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void runPhaseWithSuccessfulFlowProcessing() throws Exception {
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendResponseWhenFlowExecutionFailsAndExceptionIsHandled() throws MuleException {
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)true);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendFailureResponseWhenFlowExecutionFailsAndExceptionIsNotHandled() throws MuleException {
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)Matchers.any(MessagingException.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void callExceptionHandlerWhenSuccessfulExecutionFailsWritingResponse() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)AsyncResponseFlowProcessingPhaseTestCase.this.mockException, (MuleEvent)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when((Object)this.mockTemplate)).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void doNotCallExceptionHandlerWhenFailureExecutionFailsWritingResponse() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
                callback.responseSentWithFailure((Exception)AsyncResponseFlowProcessingPhaseTestCase.this.mockException, ((MessagingException)invocationOnMock.getArguments()[0]).getEvent());
                return null;
            }
        }).when((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)Matchers.any(MessagingException.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        this.verifyOnlyFailureWasCalled((Exception)this.mockException);
    }

    private void verifyOnlySuccessfulWasCalled() {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any(Exception.class));
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseSuccessfully();
    }

    private void verifyOnlyFailureWasCalled(Exception e) {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseFailure(e);
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
    }
}

