/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.construct.FlowConstruct;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.construct.Flow;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.security.MuleSecurityManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;

@SmallTest
public class QueueManagerLifecycleOrderTestCase
extends AbstractMuleTestCase {
    private List<Object> startStopOrder = new ArrayList<Object>();
    private RecordingTQM rtqm = new RecordingTQM();

    @Test
    public void testStartupOrder() throws Exception {
        MuleContext muleContext = new DefaultMuleContextFactory().createMuleContext((ConfigurationBuilder)new QueueManagerOnlyConfigurationBuilder());
        RecordingFlow fc = new RecordingFlow("dummy", muleContext);
        muleContext.getRegistry().registerFlowConstruct((FlowConstruct)fc);
        muleContext.start();
        muleContext.stop();
        Assert.assertEquals((long)4L, (long)this.startStopOrder.size());
        Assert.assertSame((Object)this.rtqm, (Object)this.startStopOrder.get(0));
        Assert.assertSame((Object)((Object)fc), (Object)this.startStopOrder.get(1));
        Assert.assertSame((Object)((Object)fc), (Object)this.startStopOrder.get(2));
        Assert.assertSame((Object)this.rtqm, (Object)this.startStopOrder.get(3));
    }

    private class QueueManagerOnlyConfigurationBuilder
    extends DefaultsConfigurationBuilder {
        private QueueManagerOnlyConfigurationBuilder() {
        }

        protected void doConfigure(MuleContext muleContext) throws Exception {
            muleContext.getRegistry().registerObject("_muleQueueManager", (Object)QueueManagerLifecycleOrderTestCase.this.rtqm);
            muleContext.getRegistry().registerObject("_muleSecurityManager", (Object)new MuleSecurityManager());
        }
    }

    private class RecordingFlow
    extends Flow {
        public RecordingFlow(String name, MuleContext muleContext) {
            super(name, muleContext);
        }

        public void doStart() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public void doStop() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }
    }

    private class RecordingTQM
    implements QueueManager {
        private RecordingTQM() {
        }

        public void start() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public void stop() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public QueueSession getQueueSession() {
            throw new NotImplementedException();
        }

        public void setDefaultQueueConfiguration(QueueConfiguration config) {
            throw new NotImplementedException();
        }

        public void setQueueConfiguration(String queueName, QueueConfiguration config) {
            throw new NotImplementedException();
        }
    }
}

