/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor.rewriter;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;

public class SourceRewriterMain {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Please specify a sourcefile.");
            return;
        }
        DefaultRubyParser parser = RubyParserPool.getInstance().borrowParser();
        parser.setWarnings(new NullWarnings());
        LexerSource lexerSource = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(args[0])));
            lexerSource = new LexerSource(args[0], (Reader)reader, 0);
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not find the file:");
            System.err.println(args[0]);
            return;
        }
        Node rootNode = parser.parse(new RubyParserConfiguration(), lexerSource).getAST();
        if (rootNode == null) {
            System.err.println("Source File seems to be empty.");
            return;
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(args[0])));
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
        }
        catch (IOException e) {
            System.err.println("Could not read the Sourcefile.");
        }
        ReWriteVisitor visitor = new ReWriteVisitor(System.out, buffer.toString());
        rootNode.accept(visitor);
        visitor.flushStream();
        System.out.println("\n");
    }
}

