/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRoutingStrategy;
import org.mule.routing.CorrelationMode;
import org.mule.routing.outbound.FilteringOutboundRouter;

public abstract class AbstractSequenceRouter
extends FilteringOutboundRouter {
    @Override
    public MuleEvent route(MuleEvent event) throws RoutingException {
        MuleMessage message = event.getMessage();
        if (this.routes == null || this.routes.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), event, null);
        }
        if (this.enableCorrelation != CorrelationMode.NEVER) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == CorrelationMode.IF_NOT_SET) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(this.routes.size());
            }
        }
        ArrayList<MuleEvent> results = new ArrayList<MuleEvent>(this.routes.size());
        try {
            for (int i = 0; i < this.routes.size(); ++i) {
                OutboundEndpoint endpoint;
                MessageProcessor mp = this.getRoute(i, event);
                OutboundEndpoint outboundEndpoint = endpoint = mp instanceof OutboundEndpoint ? (OutboundEndpoint)mp : null;
                if (endpoint != null && endpoint.getFilter() != null && (endpoint.getFilter() == null || !endpoint.getFilter().accept(message))) continue;
                AbstractRoutingStrategy.validateMessageIsNotConsumable(event, message);
                MuleMessage clonedMessage = this.cloneMessage(event, message);
                MuleEvent result = this.sendRequest(event, clonedMessage, mp, true);
                if (result != null && !VoidMuleEvent.getInstance().equals(result)) {
                    results.add(result);
                }
                if (this.continueRoutingMessageAfter(result)) {
                    continue;
                }
                break;
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(event, (MessageProcessor)this.routes.get(0), (Throwable)e);
        }
        return this.resultsHandler.aggregateResults(results, event, this.muleContext);
    }

    protected abstract boolean continueRoutingMessageAfter(MuleEvent var1) throws MuleException;
}

