/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.api.transport.PropertyScope;
import org.mule.endpoint.DynamicURIInboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.servlet.AbstractReceiverServlet;
import org.mule.transport.servlet.CachedHttpServletRequest;
import org.mule.transport.servlet.ServletConnector;
import org.mule.transport.servlet.i18n.ServletMessages;
import org.mule.util.PropertiesUtils;

public class MuleReceiverServlet
extends AbstractReceiverServlet {
    private static final long serialVersionUID = 6631307373079767439L;
    protected ServletConnector connector = null;
    private boolean useCachedHttpServletRequest = false;

    @Override
    protected void doInit() throws ServletException {
        this.connector = this.getOrCreateServletConnector(this.getServletConfig().getInitParameter("org.mule.servlet.connector.name"));
    }

    protected ServletConnector getOrCreateServletConnector(String name) throws ServletException {
        ServletConnector servletConnector;
        if (name == null) {
            servletConnector = (ServletConnector)new TransportFactory(this.muleContext).getConnectorByProtocol("servlet");
            if (servletConnector == null) {
                servletConnector = new ServletConnector(this.muleContext);
                servletConnector.setName("_generatedServletConnector");
                try {
                    this.muleContext.getRegistry().registerConnector((Connector)servletConnector);
                }
                catch (MuleException e) {
                    throw new ServletException("Failed to register the ServletConnector", (Throwable)e);
                }
            }
        } else {
            servletConnector = (ServletConnector)this.muleContext.getRegistry().lookupConnector(name);
            if (servletConnector == null) {
                throw new ServletException(ServletMessages.noServletConnectorFound(name).toString());
            }
        }
        this.useCachedHttpServletRequest = servletConnector.isUseCachedHttpServletRequest();
        return servletConnector;
    }

    protected void setupRequestMessage(HttpServletRequest request, MuleMessage requestMessage, MessageReceiver receiver) {
        String path;
        EndpointURI uri = receiver.getEndpointURI();
        String reqUri = request.getRequestURI();
        requestMessage.setProperty("http.request.path", (Object)reqUri, PropertyScope.INBOUND);
        String queryString = request.getQueryString();
        if (queryString != null) {
            reqUri = reqUri + "?" + queryString;
        }
        requestMessage.setProperty("http.request", (Object)reqUri, PropertyScope.INBOUND);
        if ("servlet".equals(uri.getScheme())) {
            path = HttpConnector.normalizeUrl((String)request.getContextPath());
            path = "/".equals(path) ? HttpConnector.normalizeUrl((String)request.getServletPath()) : path + HttpConnector.normalizeUrl((String)request.getServletPath());
            String pathPart2 = uri.getAddress();
            path = !path.endsWith("/") ? path + HttpConnector.normalizeUrl((String)pathPart2) : (pathPart2.startsWith("/") ? path + pathPart2.substring(1) : path + pathPart2);
        } else {
            path = HttpConnector.normalizeUrl((String)uri.getPath());
        }
        requestMessage.setProperty("http.context.path", (Object)path, PropertyScope.INBOUND);
        requestMessage.setProperty("http.context.uri", (Object)receiver.getEndpointURI().getAddress(), PropertyScope.INBOUND);
        this.setupRequestMessage(request, requestMessage);
    }

    protected void setupRequestMessage(HttpServletRequest request, MuleMessage requestMessage) {
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        if (method.equalsIgnoreCase("PATCH")) {
            this.doAllMethods(request, response);
        } else {
            super.service(request, response);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAllMethods(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAllMethods(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAllMethods(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAllMethods(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAllMethods(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAllMethods(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAllMethods(req, resp);
    }

    protected void doAllMethods(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.useCachedHttpServletRequest) {
                request = new CachedHttpServletRequest((HttpServletRequest)request);
            }
            MessageReceiver receiver = this.getReceiverForURI((HttpServletRequest)request);
            this.processHttpRequest((HttpServletRequest)request, response, receiver);
        }
        catch (Exception e) {
            this.handleException(e, ServletMessages.failedToProcessRequest().getMessage(), response);
        }
    }

    protected void processHttpRequest(HttpServletRequest request, HttpServletResponse response, MessageReceiver receiver) throws Exception {
        MuleMessage requestMessage = receiver.createMuleMessage((Object)request);
        requestMessage.setProperty("http.method", (Object)request.getMethod(), PropertyScope.INBOUND);
        this.setupRequestMessage(request, requestMessage, receiver);
        MuleEvent event = this.routeMessage(receiver, requestMessage, request);
        MuleMessage result = event == null ? null : event.getMessage();
        this.writeResponse(response, result);
    }

    protected MuleEvent routeMessage(MessageReceiver receiver, MuleMessage requestMessage, HttpServletRequest request) throws MuleException {
        return receiver.routeMessage(requestMessage);
    }

    protected MessageReceiver getReceiverForURI(HttpServletRequest httpServletRequest) throws EndpointException {
        String uri = this.getReceiverName(httpServletRequest);
        if (uri == null) {
            throw new EndpointException(HttpMessages.unableToGetEndpointUri((String)httpServletRequest.getRequestURI()));
        }
        MessageReceiver receiver = this.getReceivers().get(uri);
        if (receiver == null) {
            receiver = HttpConnector.findReceiverByStem(this.connector.getReceivers(), (String)uri);
        }
        if (receiver == null) {
            receiver = this.matchReceiverByWildcard(uri, receiver);
        }
        if (receiver == null) {
            throw new NoReceiverForEndpointException(uri);
        }
        InboundEndpoint endpoint = receiver.getEndpoint();
        if (!(endpoint instanceof DynamicURIInboundEndpoint)) {
            endpoint = new DynamicURIInboundEndpoint(receiver.getEndpoint());
            receiver.setEndpoint(endpoint);
        }
        MuleEndpointURI epURI = new MuleEndpointURI(this.getRequestUrl(httpServletRequest), this.muleContext);
        try {
            epURI.initialise();
            epURI.getParams().setProperty("servlet.endpoint", "true");
            ((DynamicURIInboundEndpoint)endpoint).setEndpointURI((EndpointURI)epURI);
        }
        catch (InitialisationException e) {
            throw new EndpointException((Throwable)e);
        }
        return receiver;
    }

    protected MessageReceiver matchReceiverByWildcard(String uri, MessageReceiver receiver) {
        for (Object key : this.getReceivers().keySet()) {
            if (!new WildcardFilter(key.toString()).accept((Object)uri)) continue;
            receiver = this.connector.getReceivers().get(key);
            break;
        }
        return receiver;
    }

    protected String getRequestUrl(HttpServletRequest httpServletRequest) {
        String queryString;
        StringBuilder url = new StringBuilder();
        url.append(httpServletRequest.getScheme());
        url.append("://");
        url.append(httpServletRequest.getServerName());
        url.append(":");
        url.append(httpServletRequest.getServerPort());
        url.append(httpServletRequest.getServletPath());
        String pathInfo = httpServletRequest.getPathInfo();
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if ((queryString = httpServletRequest.getQueryString()) != null) {
            url.append("?");
            url.append(queryString);
        }
        return url.toString();
    }

    protected String getReceiverName(HttpServletRequest httpServletRequest) {
        Properties params;
        String name = httpServletRequest.getPathInfo();
        if (name == null && (name = httpServletRequest.getServletPath()) == null && (name = httpServletRequest.getParameter("endpoint")) == null && (name = (params = PropertiesUtils.getPropertiesFromQueryString((String)httpServletRequest.getQueryString())).getProperty("endpoint")) == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    protected Map<Object, MessageReceiver> getReceivers() {
        return this.connector.getReceivers();
    }

    @Override
    protected void handleException(Throwable t, String message, HttpServletResponse response) {
        MuleEvent responseEvent = null;
        if (t instanceof MessagingException) {
            MuleEvent event = ((MessagingException)t).getEvent();
            responseEvent = event.getFlowConstruct().getExceptionListener().handleException((Exception)t, event);
            if (responseEvent != null && responseEvent.getMessage().getExceptionPayload() != null && responseEvent.getMessage().getExceptionPayload().getException() instanceof MessagingException) {
                message = responseEvent.getMessage().getExceptionPayload().getException().getMessage();
            }
            if (responseEvent != null && responseEvent.getMessage().getExceptionPayload() == null) {
                try {
                    this.writeResponse(response, responseEvent.getMessage());
                    return;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to write on response: " + e.getMessage()), (Throwable)e);
                }
            }
        } else if (t instanceof Exception) {
            this.muleContext.getExceptionListener().handleException((Exception)t);
        }
        super.handleException(t, message, response);
    }
}

