/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.transport.ssl.api.TlsContextFactory;

public class DefaultTlsContextFactory
implements TlsContextFactory {
    private String name;
    private TlsConfiguration tlsConfiguration = new TlsConfiguration(null);
    private boolean initialized = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeyStorePath() {
        return this.tlsConfiguration.getKeyStore();
    }

    public void setKeyStorePath(String name) throws IOException {
        this.tlsConfiguration.setKeyStore(name);
    }

    public String getKeyStoreType() {
        return this.tlsConfiguration.getKeyStoreType();
    }

    public void setKeyStoreType(String keyStoreType) {
        this.tlsConfiguration.setKeyStoreType(keyStoreType);
    }

    public String getKeyStorePassword() {
        return this.tlsConfiguration.getKeyStorePassword();
    }

    public void setKeyStorePassword(String storePassword) {
        this.tlsConfiguration.setKeyStorePassword(storePassword);
    }

    public String getKeyManagerPassword() {
        return this.tlsConfiguration.getKeyPassword();
    }

    public void setKeyManagerPassword(String keyManagerPassword) {
        this.tlsConfiguration.setKeyPassword(keyManagerPassword);
    }

    public String getKeyManagerAlgorithm() {
        return this.tlsConfiguration.getKeyManagerAlgorithm();
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.tlsConfiguration.setKeyManagerAlgorithm(keyManagerAlgorithm);
    }

    public String getTrustStorePath() {
        return this.tlsConfiguration.getTrustStore();
    }

    public void setTrustStorePath(String trustStorePath) throws IOException {
        this.tlsConfiguration.setTrustStore(trustStorePath);
    }

    public String getTrustStoreType() {
        return this.tlsConfiguration.getTrustStoreType();
    }

    public void setTrustStoreType(String trustStoreType) {
        this.tlsConfiguration.setTrustStoreType(trustStoreType);
    }

    public String getTrustStorePassword() {
        return this.tlsConfiguration.getTrustStorePassword();
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.tlsConfiguration.setTrustStorePassword(trustStorePassword);
    }

    public String getTrustManagerAlgorithm() {
        return this.tlsConfiguration.getTrustManagerAlgorithm();
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.tlsConfiguration.setTrustManagerAlgorithm(trustManagerAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLContext createSslContext() throws KeyManagementException, NoSuchAlgorithmException, CreateException {
        DefaultTlsContextFactory defaultTlsContextFactory = this;
        synchronized (defaultTlsContextFactory) {
            if (!this.initialized) {
                this.tlsConfiguration.initialise(null == this.getKeyStorePath(), "javax.net");
                this.initialized = true;
            }
        }
        return this.tlsConfiguration.getSslContext();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.tlsConfiguration.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.tlsConfiguration.getEnabledProtocols();
    }

    @Override
    public boolean isKeyStoreConfigured() {
        return this.tlsConfiguration.getKeyStore() != null;
    }

    @Override
    public boolean isTrustStoreConfigured() {
        return this.tlsConfiguration.getTrustStore() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultTlsContextFactory)) {
            return false;
        }
        DefaultTlsContextFactory that = (DefaultTlsContextFactory)o;
        return this.tlsConfiguration.equals((Object)that.tlsConfiguration);
    }

    public int hashCode() {
        return this.tlsConfiguration.hashCode();
    }
}

