/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.sftp.SftpConnector;
import org.mule.transport.sftp.SftpInputStream;
import org.mule.transport.sftp.SftpReceiverRequesterUtil;
import org.mule.transport.sftp.SftpStream;
import org.mule.transport.sftp.notification.SftpNotifier;
import org.mule.util.ValueHolder;
import org.mule.util.lock.LockFactory;

public class SftpMessageReceiver
extends AbstractPollingMessageReceiver {
    private SftpReceiverRequesterUtil sftpRRUtil = null;
    private LockFactory lockFactory;
    private boolean poolOnPrimaryInstanceOnly;
    protected AtomicBoolean connected = new AtomicBoolean(false);

    public SftpMessageReceiver(SftpConnector connector, FlowConstruct flow, InboundEndpoint endpoint, long frequency) throws CreateException {
        super((Connector)connector, flow, endpoint);
        this.setFrequency(frequency);
        this.sftpRRUtil = this.createSftpReceiverRequesterUtil(endpoint);
    }

    protected SftpReceiverRequesterUtil createSftpReceiverRequesterUtil(InboundEndpoint endpoint) {
        return new SftpReceiverRequesterUtil((ImmutableEndpoint)endpoint);
    }

    public SftpMessageReceiver(SftpConnector connector, FlowConstruct flow, InboundEndpoint endpoint) throws CreateException {
        this(connector, flow, endpoint, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Polling. Called at endpoint " + this.endpoint.getEndpointURI()));
        }
        try {
            Object[] files;
            if (!this.connected.get()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Skipping poll since message receiver is not yet connected");
                }
                return;
            }
            try {
                files = this.sftpRRUtil.getAvailableFiles(false);
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e, (Connectable)this);
            }
            if (files.length == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Polling. No matching files found at endpoint " + this.endpoint.getEndpointURI()));
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Polling. " + files.length + " files found at " + this.endpoint.getEndpointURI() + ":" + Arrays.toString(files)));
                }
                for (String string : files) {
                    if (this.getLifecycleState().isStopping()) break;
                    Lock fileLock = this.lockFactory.createLock(this.createLockId(string));
                    if (!fileLock.tryLock(10L, TimeUnit.MILLISECONDS)) continue;
                    try {
                        this.routeFile(string);
                    }
                    finally {
                        fileLock.unlock();
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Polling. Routed all " + files.length + " files found at " + this.endpoint.getEndpointURI()));
                }
            }
        }
        catch (MessagingException e) {
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in poll", (Throwable)e);
            this.getEndpoint().getMuleContext().getExceptionListener().handleException(e);
            throw e;
        }
    }

    String createLockId(String file) {
        return this.connector.getName() + "-" + this.endpoint.getEndpointURI().getPath() + "-" + file;
    }

    protected void doInitialise() throws InitialisationException {
        this.lockFactory = this.getEndpoint().getMuleContext().getLockFactory();
        boolean synchronousProcessing = false;
        if (this.getFlowConstruct() instanceof Flow) {
            synchronousProcessing = ((Flow)this.getFlowConstruct()).getProcessingStrategy() instanceof SynchronousProcessingStrategy;
        }
        this.poolOnPrimaryInstanceOnly = Boolean.valueOf(System.getProperty("mule.transport.sftp.singlepollinstance", "false")) != false || !synchronousProcessing;
    }

    protected boolean pollOnPrimaryInstanceOnly() {
        return this.poolOnPrimaryInstanceOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void routeFile(final String path) throws Exception {
        final ValueHolder inputStreamReference = new ValueHolder();
        ExecutionTemplate executionTemplate = this.createExecutionTemplate();
        try {
            executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                public MuleEvent process() throws Exception {
                    SftpNotifier notifier = new SftpNotifier((SftpConnector)SftpMessageReceiver.this.connector, SftpMessageReceiver.this.createNullMuleMessage(), SftpMessageReceiver.this.endpoint, SftpMessageReceiver.this.flowConstruct.getName());
                    InputStream inputStream = SftpMessageReceiver.this.sftpRRUtil.retrieveFile(path, notifier);
                    inputStreamReference.set((Object)inputStream);
                    if (SftpMessageReceiver.this.logger.isDebugEnabled()) {
                        SftpMessageReceiver.this.logger.debug((Object)("Routing file: " + path));
                    }
                    MuleMessage message = SftpMessageReceiver.this.createMuleMessage(inputStream);
                    message.setProperty("filename", (Object)path, PropertyScope.INBOUND);
                    message.setProperty("originalFilename", (Object)path, PropertyScope.INBOUND);
                    notifier.setMessage(message);
                    SftpMessageReceiver.this.routeMessage(message);
                    if (SftpMessageReceiver.this.logger.isDebugEnabled()) {
                        SftpMessageReceiver.this.logger.debug((Object)("Routed file: " + path));
                    }
                    return null;
                }
            });
            SftpStream sftpStream = this.getSftpStream((ValueHolder<InputStream>)inputStreamReference);
            if (sftpStream != null) {
                sftpStream.performPostProcessingOnClose(true);
            }
        }
        catch (Exception e) {
            SftpStream sftpStream = this.getSftpStream((ValueHolder<InputStream>)inputStreamReference);
            if (sftpStream != null) {
                sftpStream.setErrorOccurred();
            }
        }
        finally {
            SftpStream sftpStream = this.getSftpStream((ValueHolder<InputStream>)inputStreamReference);
            if (sftpStream != null && sftpStream.isClosed()) {
                sftpStream.postProcess();
            }
        }
    }

    private SftpStream getSftpStream(ValueHolder<InputStream> inputStreamReference) {
        InputStream inputStream = (InputStream)inputStreamReference.get();
        if (inputStream instanceof SftpStream) {
            return (SftpStream)((Object)inputStream);
        }
        return null;
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        this.logger.debug((Object)"the filter said no, now trying to close the payload stream");
        try {
            SftpInputStream payload = (SftpInputStream)message.getPayload();
            payload.close();
        }
        catch (Exception e) {
            this.logger.debug((Object)"unable to close payload stream", (Throwable)e);
        }
        return super.handleUnacceptedFilter(message);
    }

    public void doConnect() throws Exception {
        this.retryTemplate.execute(new RetryCallback(){

            public void doWork(RetryContext context) throws Exception {
                try {
                    if (SftpMessageReceiver.this.logger.isDebugEnabled()) {
                        SftpMessageReceiver.this.logger.debug((Object)("Trying to connect/reconnect to SFTP server " + SftpMessageReceiver.this.endpoint.getEndpointURI()));
                    }
                    SftpMessageReceiver.this.sftpRRUtil.getAvailableFiles(false);
                    if (SftpMessageReceiver.this.logger.isDebugEnabled()) {
                        SftpMessageReceiver.this.logger.debug((Object)("Successfully connected/reconnected to SFTP server " + SftpMessageReceiver.this.endpoint.getEndpointURI()));
                    }
                    SftpMessageReceiver.this.connected.set(true);
                }
                catch (Exception e) {
                    if (SftpMessageReceiver.this.logger.isDebugEnabled()) {
                        SftpMessageReceiver.this.logger.debug((Object)("Unable to connect/reconnect to SFTP server " + SftpMessageReceiver.this.endpoint.getEndpointURI()));
                    }
                    throw new Exception("Fail to connect", e);
                }
            }

            public String getWorkDescription() {
                return "Trying to reconnect to SFTP server " + SftpMessageReceiver.this.endpoint.getEndpointURI();
            }
        }, this.getConnector().getMuleContext().getWorkManager());
    }

    public void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }
}

