/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.api.Injector;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.registry.LifecycleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.ReadOnlyRegistrationDelegate;
import org.mule.config.spring.RegistrationDelegate;
import org.mule.config.spring.SpringRegistryLifecycleManager;
import org.mule.lifecycle.RegistryLifecycleManager;
import org.mule.registry.AbstractRegistry;
import org.mule.util.StringUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringRegistry
extends AbstractRegistry
implements LifecycleRegistry,
Injector {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    public static final String SPRING_APPLICATION_CONTEXT = "springApplicationContext";
    protected ApplicationContext applicationContext;
    private boolean readOnly;
    private RegistrationDelegate registrationDelegate;
    protected AtomicBoolean springContextInitialised = new AtomicBoolean(false);

    public SpringRegistry(ApplicationContext applicationContext, MuleContext muleContext) {
        super(REGISTRY_ID, muleContext);
        this.setApplicationContext(applicationContext);
    }

    public SpringRegistry(String id, ApplicationContext applicationContext, MuleContext muleContext) {
        super(id, muleContext);
        this.setApplicationContext(applicationContext);
    }

    public SpringRegistry(ConfigurableApplicationContext applicationContext, ApplicationContext parentContext, MuleContext muleContext) {
        super(REGISTRY_ID, muleContext);
        applicationContext.setParent(parentContext);
        this.setApplicationContext((ApplicationContext)applicationContext);
    }

    public SpringRegistry(String id, ConfigurableApplicationContext applicationContext, ApplicationContext parentContext, MuleContext muleContext) {
        super(id, muleContext);
        applicationContext.setParent(parentContext);
        this.setApplicationContext((ApplicationContext)applicationContext);
    }

    private void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.readOnly = false;
            this.registrationDelegate = new ConfigurableRegistrationDelegate((ConfigurableApplicationContext)applicationContext);
        } else {
            this.readOnly = true;
            this.registrationDelegate = new ReadOnlyRegistrationDelegate();
        }
    }

    protected void doInitialise() throws InitialisationException {
        if (!this.readOnly) {
            ((ConfigurableApplicationContext)this.applicationContext).refresh();
        }
        this.initTransformers();
        this.springContextInitialised.set(true);
    }

    private void initTransformers() {
        this.applicationContext.getBeansOfType(TransformerResolver.class);
        this.applicationContext.getBeansOfType(Converter.class);
    }

    public void doDispose() {
        if (!this.springContextInitialised.get()) {
            return;
        }
        if (!this.isReadOnly() && ((ConfigurableApplicationContext)this.applicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
        this.applicationContext = null;
        this.springContextInitialised.set(false);
    }

    protected RegistryLifecycleManager createLifecycleManager() {
        return new SpringRegistryLifecycleManager(this.getRegistryId(), this, this.muleContext);
    }

    public <T> T lookupObject(String key) {
        return (T)this.lookupObject(key, true);
    }

    public Object lookupObject(String key, boolean applyLifecycle) {
        Object object;
        if (StringUtils.isBlank((String)key)) {
            this.logger.warn(MessageFactory.createStaticMessage((String)"Detected a lookup attempt with an empty or null key").getMessage(), new Throwable().fillInStackTrace());
            return null;
        }
        if (key.equals(SPRING_APPLICATION_CONTEXT) && this.applicationContext != null) {
            return this.applicationContext;
        }
        try {
            object = this.applicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
        if (applyLifecycle && !this.applicationContext.isSingleton(key)) {
            try {
                this.getLifecycleManager().applyCompletedPhases(object);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)("Could not apply lifecycle into prototype object " + key)), (Throwable)e);
            }
        }
        return object;
    }

    public <T> Collection<T> lookupObjects(Class<T> type) {
        return this.lookupByType(type).values();
    }

    public <T> Collection<T> lookupLocalObjects(Class<T> type) {
        return this.internalLookupByTypeWithoutAncestors(type, true, true).values();
    }

    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.lookupEntriesForLifecycle(type).values();
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.internalLookupByType(type, true, true);
    }

    public void registerObject(String key, Object value) throws RegistrationException {
        this.registrationDelegate.registerObject(key, value);
    }

    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registrationDelegate.registerObject(key, value, metadata);
    }

    public void registerObjects(Map<String, Object> objects) throws RegistrationException {
        this.registrationDelegate.registerObjects(objects);
    }

    protected Object doUnregisterObject(String key) throws RegistrationException {
        return this.registrationDelegate.unregisterObject(key);
    }

    public Object applyLifecycle(Object object) throws MuleException {
        this.getLifecycleManager().applyCompletedPhases(object);
        return object;
    }

    public Object applyLifecycle(Object object, String phase) throws MuleException {
        if (phase == null) {
            this.getLifecycleManager().applyCompletedPhases(object);
        } else {
            this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        }
        return object;
    }

    public <T> T inject(T object) {
        try {
            return this.initialiseObject((ConfigurableApplicationContext)this.applicationContext, "", object);
        }
        catch (LifecycleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private <T> T initialiseObject(ConfigurableApplicationContext applicationContext, String key, T object) throws LifecycleException {
        applicationContext.getBeanFactory().autowireBean(object);
        Object initialised = applicationContext.getBeanFactory().initializeBean(object, key);
        return (T)initialised;
    }

    protected <T> Map<String, T> internalLookupByType(Class<T> type, boolean nonSingletons, boolean eagerInit) {
        try {
            return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type, (boolean)nonSingletons, (boolean)eagerInit);
        }
        catch (FatalBeanException fbex) {
            String message = String.format("Failed to lookup beans of type %s from the Spring registry", type);
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)message), (Throwable)fbex);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    protected <T> Map<String, T> internalLookupByTypeWithoutAncestors(Class<T> type, boolean nonSingletons, boolean eagerInit) {
        try {
            return this.applicationContext.getBeansOfType(type, nonSingletons, eagerInit);
        }
        catch (FatalBeanException fbex) {
            String message = String.format("Failed to lookup beans of type %s from the Spring registry", type);
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)message), (Throwable)fbex);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(e.getMessage(), (Throwable)e);
            }
            return Collections.emptyMap();
        }
    }

    protected <T> Map<String, T> lookupEntriesForLifecycle(Class<T> type) {
        return this.internalLookupByTypeWithoutAncestors(type, false, false);
    }

    protected Map<String, Object> getDepencies(String key) {
        if (!this.readOnly) {
            HashMap<String, Object> dependents = new HashMap<String, Object>();
            for (String dependentKey : ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getDependenciesForBean(key)) {
                dependents.put(dependentKey, this.get(dependentKey));
            }
            return dependents;
        }
        throw new UnsupportedOperationException("This operation is only available when this registry is backed by a ConfigurableApplicationContext");
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRemote() {
        return false;
    }

    private class ConfigurableRegistrationDelegate
    implements RegistrationDelegate {
        private final ConfigurableApplicationContext applicationContext;

        private ConfigurableRegistrationDelegate(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Override
        public void registerObject(String key, Object value) throws RegistrationException {
            this.doRegisterObject(key, value);
        }

        @Override
        public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
            this.registerObject(key, value);
        }

        @Override
        public void registerObjects(Map<String, Object> objects) throws RegistrationException {
            if (objects == null || objects.isEmpty()) {
                return;
            }
            for (Map.Entry<String, Object> entry : objects.entrySet()) {
                this.registerObject(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object unregisterObject(String key) throws RegistrationException {
            Object object = this.applicationContext.getBean(key);
            if (this.applicationContext.getBeanFactory().containsBeanDefinition(key)) {
                ((BeanDefinitionRegistry)this.applicationContext.getBeanFactory()).removeBeanDefinition(key);
            }
            ((DefaultListableBeanFactory)this.applicationContext.getBeanFactory()).destroySingleton(key);
            return object;
        }

        private synchronized void doRegisterObject(String key, Object value) throws RegistrationException {
            if (this.applicationContext.containsBean(key)) {
                if (SpringRegistry.this.logger.isWarnEnabled()) {
                    SpringRegistry.this.logger.warn(String.format("Spring registry already contains an object named '%s'. The previous object will be overwritten.", key));
                }
                SpringRegistry.this.unregisterObject(key);
            }
            try {
                value = SpringRegistry.this.initialiseObject(this.applicationContext, key, value);
                SpringRegistry.this.applyLifecycle(value);
                this.applicationContext.getBeanFactory().registerSingleton(key, value);
            }
            catch (Exception e) {
                throw new RegistrationException(MessageFactory.createStaticMessage((String)("Could not register object for key " + key)), (Throwable)e);
            }
        }
    }
}

