/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.RepositoryService;
import org.jbpm.pvm.internal.ant.AntHelper;

public class JbpmDeployTask
extends MatchingTask {
    private String jbpmCfg;
    private File file;
    private List<FileSet> fileSets = new ArrayList<FileSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(JbpmDeployTask.class.getClassLoader());
        try {
            ProcessEngine processEngine = AntHelper.getProcessEngine(this.jbpmCfg);
            if (this.file != null) {
                this.deployFile(processEngine, this.file);
            }
            for (FileSet fileSet : this.fileSets) {
                DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.getProject());
                File baseDir = dirScanner.getBasedir();
                Object[] excludedFiles = dirScanner.getExcludedFiles();
                Arrays.sort(excludedFiles);
                for (String fileName : dirScanner.getIncludedFiles()) {
                    if (Arrays.binarySearch(excludedFiles, fileName) >= 0) continue;
                    File file = new File(baseDir, fileName);
                    this.deployFile(processEngine, file);
                }
            }
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    protected void deployFile(ProcessEngine processEngine, File processFile) {
        NewDeployment deployment;
        block9: {
            RepositoryService repositoryService = processEngine.getRepositoryService();
            String fileName = processFile.getName();
            deployment = repositoryService.createDeployment();
            deployment.setName(fileName);
            deployment.setTimestamp(System.currentTimeMillis());
            try {
                String contentType = new URL("file", null, processFile.getPath()).openConnection().getContentType();
                if (contentType == null || "content/unknown".equals(contentType)) {
                    if (fileName.endsWith(".bar") || fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                        contentType = "application/zip";
                    } else if (fileName.endsWith(".xml")) {
                        contentType = "application/xml";
                    } else {
                        throw new BuildException("failed to determine content type of " + processFile);
                    }
                }
                if ("application/xml".equals(contentType)) {
                    this.log("deploying process file " + fileName);
                    deployment.addResourceFromFile(processFile);
                    break block9;
                }
                if ("application/zip".equals(contentType)) {
                    this.log("deploying business archive " + fileName);
                    ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(processFile));
                    deployment.addResourcesFromZipInputStream(zipInputStream);
                    break block9;
                }
                throw new BuildException("unsupported content type: " + contentType + " - only xml and zip files are allowed");
            }
            catch (IOException e) {
                throw new BuildException("failed to read: " + processFile, (Throwable)e);
            }
        }
        deployment.deploy();
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setJbpmCfg(String jbpmCfg) {
        this.jbpmCfg = jbpmCfg;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

