/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cal;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.cal.BusinessCalendar;
import org.jbpm.pvm.internal.cal.Day;
import org.jbpm.pvm.internal.cal.DayPart;
import org.jbpm.pvm.internal.cal.Duration;
import org.jbpm.pvm.internal.cal.Holiday;
import org.jbpm.pvm.internal.util.Clock;

public class BusinessCalendarImpl
implements Serializable,
BusinessCalendar {
    private static final long serialVersionUID = 1L;
    private static BusinessCalendarImpl instance = null;
    protected long oid = -1L;
    protected int version = 0;
    protected TimeZone timeZone = TimeZone.getDefault();
    protected Day[] days = null;
    protected Holiday[] holidays = null;
    protected long secondInMillis = 1000L;
    protected long minuteInMillis = 60000L;
    protected long hourInMillis = 3600000L;
    protected long dayInMillis = 24L * this.hourInMillis;
    protected long weekInMillis = 7L * this.dayInMillis;
    protected long monthInMillis = 30L * this.dayInMillis;
    protected long yearInMillis = 365L * this.dayInMillis;
    protected long businessDayInMillis = 8L * this.hourInMillis;
    protected long businessWeekInMillis = 40L * this.hourInMillis;
    protected long businessMonthInMillis = 21L * this.dayInMillis;
    protected long businessYearInMillis = 220L * this.dayInMillis;

    public static synchronized BusinessCalendarImpl getInstance() {
        if (instance == null) {
            instance = new BusinessCalendarImpl();
        }
        return instance;
    }

    public Date add(Date date, String duration) {
        return this.add(date, new Duration(duration));
    }

    public Date subtract(Date date, String duration) {
        if (duration.contains("business")) {
            throw new JbpmException("Duedate subtraction not supported for business durations");
        }
        return this.subtract(date, new Duration(duration));
    }

    public Date subtract(Date date, Duration duration) {
        Date end = null;
        long millis = this.convertToMillis(duration);
        end = new Date(date.getTime() - millis);
        if (end.before(Clock.getTime())) {
            throw new JbpmException("Duedate " + end + " in the past");
        }
        return end;
    }

    public Date add(Date date, Duration duration) {
        Date end = null;
        if (duration.isBusinessTime()) {
            boolean isInbusinessHours;
            DayPart dayPart = this.findDayPart(date);
            boolean bl = isInbusinessHours = dayPart != null;
            if (!isInbusinessHours) {
                Object[] result = new Object[2];
                this.findDay(date).findNextDayPartStart(0, date, result);
                date = (Date)result[0];
                dayPart = (DayPart)result[1];
            }
            long millis = this.convertToMillis(duration);
            end = dayPart.add(date, millis, duration.isBusinessTime());
        } else {
            long millis = this.convertToMillis(duration);
            end = new Date(date.getTime() + millis);
        }
        return end;
    }

    public long convertToMillis(Duration duration) {
        long millis = duration.getMillis();
        millis += (long)duration.getSeconds() * this.secondInMillis;
        millis += (long)duration.getMinutes() * this.minuteInMillis;
        millis += (long)duration.getHours() * this.hourInMillis;
        if (duration.isBusinessTime()) {
            millis += (long)duration.getDays() * this.businessDayInMillis;
            millis += (long)duration.getWeeks() * this.businessWeekInMillis;
            millis += (long)duration.getMonths() * this.businessMonthInMillis;
            millis += (long)duration.getYears() * this.businessYearInMillis;
        } else {
            millis += (long)duration.getDays() * this.dayInMillis;
            millis += (long)duration.getWeeks() * this.weekInMillis;
            millis += (long)duration.getMonths() * this.monthInMillis;
            millis += (long)duration.getYears() * this.yearInMillis;
        }
        return millis;
    }

    public boolean isInBusinessHours(Date date) {
        return this.findDayPart(date) != null;
    }

    public boolean isHoliday(Date date) {
        if (this.holidays != null) {
            for (Holiday holiday : this.holidays) {
                if (!holiday.includes(date)) continue;
                return true;
            }
        }
        return false;
    }

    protected Date findStartOfNextDay(Date date) {
        Calendar calendar = this.createCalendar();
        calendar.setTime(date);
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        while (this.isHoliday(date)) {
            calendar.setTime(date);
            calendar.add(5, 1);
            date = calendar.getTime();
        }
        return date;
    }

    public Calendar createCalendar() {
        return new GregorianCalendar();
    }

    protected Day findDay(Date date) {
        Calendar calendar = this.createCalendar();
        calendar.setTime(date);
        int weekDayIndex = calendar.get(7);
        return this.days[weekDayIndex];
    }

    protected DayPart findDayPart(Date date) {
        Day day;
        DayPart[] dayParts;
        DayPart dayPart = null;
        if (!this.isHoliday(date) && (dayParts = (day = this.findDay(date)).getDayParts()) != null) {
            for (int i = 0; i < dayParts.length && dayPart == null; ++i) {
                DayPart candidate = dayParts[i];
                if (!candidate.includes(date)) continue;
                dayPart = candidate;
            }
        }
        return dayPart;
    }

    protected DayPart findNextDayPart(Date date) {
        DayPart nextDayPart = null;
        while (nextDayPart == null) {
            nextDayPart = this.findDayPart(date);
            if (nextDayPart != null) continue;
            date = this.findStartOfNextDay(date);
            Object[] result = new Object[2];
            Day day = this.findDay(date);
            day.findNextDayPartStart(0, date, result);
            nextDayPart = (DayPart)result[1];
        }
        return nextDayPart;
    }

    public long getBusinessDayInMillis() {
        return this.businessDayInMillis;
    }

    public void setBusinessDayInMillis(long businessDayInMillis) {
        this.businessDayInMillis = businessDayInMillis;
    }

    public long getBusinessMonthInMillis() {
        return this.businessMonthInMillis;
    }

    public void setBusinessMonthInMillis(long businessMonthInMillis) {
        this.businessMonthInMillis = businessMonthInMillis;
    }

    public long getBusinessWeekInMillis() {
        return this.businessWeekInMillis;
    }

    public void setBusinessWeekInMillis(long businessWeekInMillis) {
        this.businessWeekInMillis = businessWeekInMillis;
    }

    public long getBusinessYearInMillis() {
        return this.businessYearInMillis;
    }

    public void setBusinessYearInMillis(long businessYearInMillis) {
        this.businessYearInMillis = businessYearInMillis;
    }

    public long getDayInMillis() {
        return this.dayInMillis;
    }

    public void setDayInMillis(long dayInMillis) {
        this.dayInMillis = dayInMillis;
    }

    public Day[] getDays() {
        return this.days;
    }

    public void setDays(Day[] days) {
        this.days = days;
    }

    public Holiday[] getHolidays() {
        return this.holidays;
    }

    public void setHolidays(Holiday[] holidays) {
        this.holidays = holidays;
    }

    public long getHourInMillis() {
        return this.hourInMillis;
    }

    public void setHourInMillis(long hourInMillis) {
        this.hourInMillis = hourInMillis;
    }

    public long getMinuteInMillis() {
        return this.minuteInMillis;
    }

    public void setMinuteInMillis(long minuteInMillis) {
        this.minuteInMillis = minuteInMillis;
    }

    public long getMonthInMillis() {
        return this.monthInMillis;
    }

    public void setMonthInMillis(long monthInMillis) {
        this.monthInMillis = monthInMillis;
    }

    public long getSecondInMillis() {
        return this.secondInMillis;
    }

    public void setSecondInMillis(long secondInMillis) {
        this.secondInMillis = secondInMillis;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public long getWeekInMillis() {
        return this.weekInMillis;
    }

    public void setWeekInMillis(long weekInMillis) {
        this.weekInMillis = weekInMillis;
    }

    public long getYearInMillis() {
        return this.yearInMillis;
    }

    public void setYearInMillis(long yearInMillis) {
        this.yearInMillis = yearInMillis;
    }
}

