/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.client.ClientProcessDefinition;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.OpenProcessDefinition;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;

public class ProcessDefinitionImpl
extends CompositeElementImpl
implements OpenProcessDefinition,
ClientProcessDefinition {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)ProcessDefinitionImpl.class.getName());
    public static final int UNASSIGNED_VERSION = -1;
    protected String key;
    protected String id;
    protected int version = -1;
    protected String packageName;
    protected Date deploymentTime;
    protected long deploymentDbid;
    protected boolean isSuspended = false;
    protected ActivityImpl initial;
    protected Map<String, TaskDefinitionImpl> taskDefinitions = new HashMap<String, TaskDefinitionImpl>();
    protected String imageResourceName = null;

    public ProcessDefinitionImpl() {
        this.processDefinition = this;
    }

    public ClientProcessInstance createProcessInstance() {
        return this.createProcessInstance(null, null);
    }

    public ClientProcessInstance createProcessInstance(String key) {
        return this.createProcessInstance(key, null);
    }

    public ClientProcessInstance createProcessInstance(String key, Execution superProcessExecution) {
        if (this.isSuspended) {
            throw new JbpmException("process definition " + this.id + " is suspended");
        }
        ExecutionImpl processInstance = this.newProcessInstance();
        log.debug("creating new execution for process '" + this.name + "'");
        if (superProcessExecution != null) {
            ExecutionImpl superProcessExecutionImpl = (ExecutionImpl)superProcessExecution;
            processInstance.setSuperProcessExecution(superProcessExecutionImpl);
            superProcessExecutionImpl.setSubProcessInstance(processInstance);
        }
        processInstance.initializeProcessInstance(this, key);
        return processInstance;
    }

    public ClientProcessInstance startProcessInstance() {
        ClientProcessInstance processInstance = this.createProcessInstance(null, null);
        processInstance.start();
        return processInstance;
    }

    public ClientProcessInstance startProcessInstance(String key) {
        ClientProcessInstance processInstance = this.createProcessInstance(key, null);
        processInstance.start();
        return processInstance;
    }

    protected ExecutionImpl newProcessInstance() {
        return new ExecutionImpl();
    }

    public void addTaskDefinitionImpl(TaskDefinitionImpl taskDefinition) {
        this.taskDefinitions.put(taskDefinition.getName(), taskDefinition);
    }

    public TaskDefinitionImpl getTaskDefinition(String name) {
        return this.taskDefinitions.get(name);
    }

    public String toString() {
        return this.name != null ? "process(" + this.name + ")" : "process";
    }

    public String getDeploymentId() {
        return Long.toString(this.deploymentDbid);
    }

    public ActivityImpl getInitial() {
        return this.initial;
    }

    public void setInitial(ActivityImpl initial) {
        this.initial = initial;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDeploymentDbid(long deploymentDbid) {
        this.deploymentDbid = deploymentDbid;
    }

    public String getImageResourceName() {
        return this.imageResourceName;
    }

    public void setImageResourceName(String imageResourceName) {
        this.imageResourceName = imageResourceName;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }
}

