/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.session.RepositorySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentClassLoader
extends ClassLoader {
    private final String deploymentId;

    public DeploymentClassLoader(ClassLoader parent, String deploymentId) {
        super(parent);
        this.deploymentId = deploymentId;
    }

    @Override
    public URL findResource(String name) {
        URL url = null;
        byte[] bytes = this.getDeployment().getBytes(name);
        if (bytes != null) {
            try {
                url = new URL(null, "jbpm://" + this.deploymentId + "/" + name, new BytesUrlStreamHandler(bytes));
            }
            catch (MalformedURLException e) {
                throw new JbpmException("couldn't create url", (Throwable)e);
            }
        }
        return url;
    }

    protected DeploymentImpl getDeployment() {
        RepositorySession repositorySession = EnvironmentImpl.getFromCurrent(RepositorySession.class);
        return repositorySession.getDeployment(this.deploymentId);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        String packageName;
        Package classPackage;
        String fileName = name.replace('.', '/') + ".class";
        byte[] bytecode = this.getDeployment().getBytes(fileName);
        if (bytecode == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = this.defineClass(name, bytecode, 0, bytecode.length);
        int packageIndex = name.lastIndexOf(46);
        if (packageIndex != -1 && (classPackage = this.getPackage(packageName = name.substring(0, packageIndex))) == null) {
            Package myPackage = this.getClass().getPackage();
            if (myPackage != null) {
                this.definePackage(packageName, myPackage.getSpecificationTitle(), myPackage.getSpecificationVersion(), myPackage.getSpecificationVendor(), myPackage.getImplementationTitle(), myPackage.getImplementationVersion(), myPackage.getImplementationVendor(), null);
            } else {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
        }
        return clazz;
    }

    private static class BytesUrlConnection
    extends URLConnection {
        private final byte[] bytes;

        public BytesUrlConnection(byte[] bytes, URL url) {
            super(url);
            this.bytes = bytes;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    private static class BytesUrlStreamHandler
    extends URLStreamHandler {
        private final byte[] bytes;

        public BytesUrlStreamHandler(byte[] bytes) {
            this.bytes = bytes;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new BytesUrlConnection(this.bytes, u);
        }
    }
}

