/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.ConnectionFactory;
import org.mule.api.MuleContext;
import org.mule.transport.jms.AbstractConnectionFactoryDecorator;
import org.mule.transport.jms.CustomCachingConnectionFactory;
import org.mule.transport.jms.Jms102bSupport;
import org.mule.transport.jms.Jms11Support;
import org.mule.transport.jms.JmsConnector;
import org.springframework.jms.connection.CachingConnectionFactory;

public class CachingConnectionFactoryDecorator
extends AbstractConnectionFactoryDecorator {
    protected CustomCachingConnectionFactory cachingConnectionFactory;

    @Override
    protected ConnectionFactory doDecorate(ConnectionFactory connectionFactory, JmsConnector jmsConnector, MuleContext muleContext) {
        if (this.resolveReuseSessionsEnabled(jmsConnector)) {
            this.cachingConnectionFactory = new CustomCachingConnectionFactory(connectionFactory, jmsConnector.getUsername(), jmsConnector.getPassword());
            this.cachingConnectionFactory.setCacheConsumers(false);
            this.cachingConnectionFactory.setCacheProducers(true);
            this.cachingConnectionFactory.setSessionCacheSize(Integer.MAX_VALUE);
            this.cachingConnectionFactory.setClientId(jmsConnector.getClientId());
            this.cachingConnectionFactory.setExceptionListener(jmsConnector);
            this.cachingConnectionFactory.setReconnectOnException(false);
            return this.cachingConnectionFactory;
        }
        return connectionFactory;
    }

    private boolean resolveReuseSessionsEnabled(JmsConnector jmsConnector) {
        return jmsConnector.getJmsSupport() instanceof Jms11Support && !(jmsConnector.getJmsSupport() instanceof Jms102bSupport) && jmsConnector.isCacheJmsSessions();
    }

    @Override
    public boolean appliesTo(ConnectionFactory connectionFactory, MuleContext muleContext) {
        return !this.isXaConnectionFactory(connectionFactory) && !this.isConnectionFactoryWrapper(connectionFactory) && !(connectionFactory instanceof CachingConnectionFactory);
    }
}

