/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.transaction.TransactionCollection;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractReceiverWorker;
import org.mule.transport.ConnectException;
import org.mule.transport.jms.JmsClientAcknowledgeTransaction;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.JmsTransaction;
import org.mule.transport.jms.ReusableSessionWrapperFactory;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.transport.jms.reconnect.ReconnectWorkManager;
import org.mule.transport.jms.redelivery.RedeliveryHandler;
import org.mule.util.ClassUtils;

public class MultiConsumerJmsMessageReceiver
extends AbstractMessageReceiver {
    protected final List<SubReceiver> consumers;
    protected final int receiversCount;
    private final JmsConnector jmsConnector;
    final boolean isTopic;
    private final ReconnectWorkManager reconnectWorkManager;
    private boolean reconnecting = false;
    private boolean started = false;

    public MultiConsumerJmsMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.jmsConnector = (JmsConnector)connector;
        this.isTopic = this.jmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)endpoint, true);
        if (this.isTopic && this.jmsConnector.getNumberOfConsumers() != 1) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Destination " + this.getEndpoint().getEndpointURI() + " is a topic, but " + this.jmsConnector.getNumberOfConsumers() + " receivers have been requested. Will configure only 1."));
            }
            this.receiversCount = 1;
        } else {
            this.receiversCount = this.jmsConnector.getNumberOfConsumers();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating " + this.receiversCount + " sub-receivers for " + endpoint.getEndpointURI()));
        }
        this.consumers = new CopyOnWriteArrayList<SubReceiver>();
        this.reconnectWorkManager = new ReconnectWorkManager(this.getEndpoint().getMuleContext());
    }

    protected synchronized void doStart() throws MuleException {
        this.started = true;
        this.reconnectWorkManager.startIfNotStarted();
        if (!this.connected.get()) {
            try {
                this.connect();
            }
            catch (Exception e) {
                throw new DefaultMuleException((Throwable)e);
            }
        } else {
            this.startSubReceivers();
        }
    }

    protected void doStop() throws MuleException {
        super.doStop();
        this.logger.debug((Object)"doStop()");
        if (this.consumers != null) {
            for (SubReceiver sub : this.consumers) {
                sub.doStop(true);
            }
        }
        this.reconnectWorkManager.dispose();
    }

    protected synchronized void doConnect() throws Exception {
        this.logger.debug((Object)"doConnect()");
        if (this.reconnecting) {
            return;
        }
        this.reconnecting = true;
        this.reconnectWorkManager.startIfNotStarted();
        this.retryTemplate.execute(new RetryCallback(){

            public void doWork(RetryContext context) throws Exception {
                try {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)"doConnect()");
                    if (!MultiConsumerJmsMessageReceiver.this.consumers.isEmpty()) {
                        if (MultiConsumerJmsMessageReceiver.this.consumers.get((int)0).connected) {
                            context.setOk();
                            MultiConsumerJmsMessageReceiver.this.reconnecting = false;
                            return;
                        }
                        throw new IllegalStateException("List should be empty, there may be a concurrency issue here (see EE-1275)");
                    }
                    for (int i = 0; i < MultiConsumerJmsMessageReceiver.this.receiversCount; ++i) {
                        SubReceiver sub = new SubReceiver();
                        sub.doConnect();
                        MultiConsumerJmsMessageReceiver.this.consumers.add(sub);
                    }
                    if (MultiConsumerJmsMessageReceiver.this.started) {
                        MultiConsumerJmsMessageReceiver.this.startSubReceivers();
                    }
                    context.setOk();
                    MultiConsumerJmsMessageReceiver.this.logger.info((Object)("Endpoint " + MultiConsumerJmsMessageReceiver.this.endpoint.getEndpointURI() + " has been successfully reconnected."));
                    MultiConsumerJmsMessageReceiver.this.reconnecting = false;
                }
                catch (Exception e) {
                    throw new Exception("Fail to connect", e);
                }
            }

            public String getWorkDescription() {
                return MultiConsumerJmsMessageReceiver.this.getConnectionDescription();
            }
        }, (WorkManager)this.reconnectWorkManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        this.logger.debug((Object)"doDisconnect()");
        for (SubReceiver sub : this.consumers) {
            try {
                sub.doDisconnect();
            }
            finally {
                sub = null;
            }
        }
        this.consumers.clear();
    }

    protected void doDispose() {
        this.logger.debug((Object)"doDispose()");
    }

    protected void startSubReceivers() throws MuleException {
        for (SubReceiver sub : this.consumers) {
            sub.doStart();
        }
    }

    public boolean shouldConsumeInEveryNode() {
        return !this.isTopic;
    }

    protected class JmsWorker
    extends AbstractReceiverWorker {
        private final SubReceiver subReceiver;

        public JmsWorker(Message message, AbstractMessageReceiver receiver, SubReceiver subReceiver) {
            super(new ArrayList(1), receiver);
            this.subReceiver = subReceiver;
            this.messages.add(message);
        }

        protected Object preProcessMessage(Object message) throws Exception {
            Message m = (Message)message;
            if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message received it is of type: " + ClassUtils.getSimpleName(message.getClass())));
                if (m.getJMSDestination() != null) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message received on " + m.getJMSDestination() + " (" + m.getJMSDestination().getClass().getName() + ")"));
                } else {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)"Message received on unknown destination");
                }
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message CorrelationId is: " + m.getJMSCorrelationID()));
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Jms Message Id is: " + m.getJMSMessageID()));
            }
            if (m.getJMSRedelivered()) {
                RedeliveryHandler redeliveryHandler = MultiConsumerJmsMessageReceiver.this.jmsConnector.getRedeliveryHandlerFactory().create();
                redeliveryHandler.setConnector(MultiConsumerJmsMessageReceiver.this.jmsConnector);
                if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message with correlationId: " + m.getJMSCorrelationID() + " has redelivered flag set, handing off to Redelivery Handler"));
                }
                redeliveryHandler.handleRedelivery(m, this.receiver.getEndpoint(), this.receiver.getFlowConstruct());
            }
            return m;
        }

        protected void bindTransaction(Transaction tx) throws TransactionException {
            if (tx instanceof JmsTransaction || tx instanceof TransactionCollection) {
                if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Binding " + this.subReceiver.session + " to " + MultiConsumerJmsMessageReceiver.this.jmsConnector.getConnection()));
                }
                tx.bindResource((Object)MultiConsumerJmsMessageReceiver.this.jmsConnector.getConnection(), (Object)ReusableSessionWrapperFactory.createWrapper(this.subReceiver.session));
            } else if (tx instanceof JmsClientAcknowledgeTransaction) {
                ((JmsClientAcknowledgeTransaction)tx).setMessage((Message)this.messages.get(0));
            }
        }
    }

    protected class SubReceiver
    implements MessageListener {
        private final Log subLogger = LogFactory.getLog(this.getClass());
        private volatile Session session;
        private volatile MessageConsumer consumer;
        protected volatile boolean connected;
        protected volatile boolean started;
        protected volatile boolean isProcessingMessage;

        protected SubReceiver() {
        }

        protected void doConnect() throws MuleException {
            this.subLogger.debug((Object)"SUB doConnect()");
            try {
                this.createConsumer();
            }
            catch (Exception e) {
                throw new LifecycleException((Throwable)e, (Object)this);
            }
            this.connected = true;
        }

        protected void doDisconnect() throws MuleException {
            this.subLogger.debug((Object)"SUB doDisconnect()");
            if (this.started) {
                this.doStop(true);
            }
            this.closeConsumer();
            this.connected = false;
        }

        protected void closeConsumer() {
            MultiConsumerJmsMessageReceiver.this.jmsConnector.closeQuietly(this.consumer);
            this.consumer = null;
            if (this.isProcessingMessage) {
                this.recoverSession();
            }
            MultiConsumerJmsMessageReceiver.this.jmsConnector.closeQuietly(this.session);
            this.session = null;
        }

        private void recoverSession() {
            try {
                this.session.recover();
            }
            catch (Exception jmsEx) {
                MultiConsumerJmsMessageReceiver.this.logger.error((Object)jmsEx);
            }
        }

        protected void doStart() throws MuleException {
            this.subLogger.debug((Object)"SUB doStart()");
            if (!this.connected) {
                this.doConnect();
            }
            try {
                MessageListener currentMessageListener = this.consumer.getMessageListener();
                if (currentMessageListener == null || currentMessageListener != this) {
                    this.consumer.setMessageListener((MessageListener)this);
                }
                this.started = true;
            }
            catch (JMSException e) {
                throw new LifecycleException((Throwable)e, (Object)this);
            }
        }

        protected void doStop(boolean force) throws MuleException {
            this.subLogger.debug((Object)"SUB doStop()");
            if (this.consumer != null) {
                try {
                    this.consumer.setMessageListener(null);
                    this.started = false;
                }
                catch (JMSException e) {
                    if (force) {
                        MultiConsumerJmsMessageReceiver.this.logger.warn((Object)("Unable to cleanly stop subreceiver: " + e.getMessage()));
                        this.started = false;
                    }
                    throw new LifecycleException((Throwable)e, (Object)this);
                }
            }
        }

        protected void createConsumer() throws Exception {
            this.subLogger.debug((Object)"SUB createConsumer()");
            boolean sessionCreated = false;
            try {
                String durableName;
                JmsSupport jmsSupport = MultiConsumerJmsMessageReceiver.this.jmsConnector.getJmsSupport();
                boolean topic = MultiConsumerJmsMessageReceiver.this.jmsConnector.getTopicResolver().isTopic(MultiConsumerJmsMessageReceiver.this.endpoint, true);
                if (this.session == null) {
                    sessionCreated = true;
                    this.session = MultiConsumerJmsMessageReceiver.this.jmsConnector.getSession(MultiConsumerJmsMessageReceiver.this.endpoint);
                }
                Destination dest = jmsSupport.createDestination(this.session, MultiConsumerJmsMessageReceiver.this.endpoint);
                String selector = null;
                JmsSelectorFilter selectorFilter = MultiConsumerJmsMessageReceiver.this.jmsConnector.getSelector(MultiConsumerJmsMessageReceiver.this.endpoint);
                if (selectorFilter != null) {
                    selector = selectorFilter.getExpression();
                } else if (MultiConsumerJmsMessageReceiver.this.endpoint.getProperties() != null) {
                    selector = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("selector");
                }
                String tempDurable = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("durable");
                boolean durable = MultiConsumerJmsMessageReceiver.this.jmsConnector.isDurable();
                if (tempDurable != null) {
                    durable = Boolean.valueOf(tempDurable);
                }
                if ((durableName = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("durableName")) == null && durable && topic) {
                    durableName = "mule." + MultiConsumerJmsMessageReceiver.this.jmsConnector.getName() + "." + MultiConsumerJmsMessageReceiver.this.endpoint.getEndpointURI().getAddress();
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                }
                try {
                    this.consumer = jmsSupport.createConsumer(this.session, dest, selector, MultiConsumerJmsMessageReceiver.this.jmsConnector.isNoLocal(), durableName, topic, MultiConsumerJmsMessageReceiver.this.endpoint);
                }
                catch (Exception e) {
                    if (sessionCreated) {
                        MultiConsumerJmsMessageReceiver.this.jmsConnector.closeQuietly(this.session);
                    }
                    throw e;
                }
            }
            catch (JMSException e) {
                throw new ConnectException((Throwable)e, (Connectable)MultiConsumerJmsMessageReceiver.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            try {
                this.isProcessingMessage = true;
                JmsWorker worker = new JmsWorker(message, MultiConsumerJmsMessageReceiver.this, this);
                worker.processMessages();
            }
            catch (Exception e) {
                RollbackSourceCallback rollbackMethod = new RollbackSourceCallback(){

                    public void rollback() {
                        SubReceiver.this.recoverSession();
                    }
                };
                if (e instanceof MessagingException) {
                    MessagingException messagingException = (MessagingException)e;
                    if (!messagingException.getEvent().isTransacted() && messagingException.causedRollback()) {
                        rollbackMethod.rollback();
                    }
                } else {
                    MultiConsumerJmsMessageReceiver.this.getEndpoint().getMuleContext().getExceptionListener().handleException(e, rollbackMethod);
                }
            }
            finally {
                this.isProcessingMessage = false;
            }
        }
    }
}

