/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.statement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;
import org.mule.module.db.internal.result.statement.StatementResultIterator;
import org.mule.module.db.internal.result.statement.StatementResultIteratorFactory;

public class GenericStatementResultIteratorFactory
implements StatementResultIteratorFactory {
    private final ResultSetHandler resultSetHandler;

    public GenericStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    @Override
    public final StatementResultIterator create(DbConnection connection, Statement statement, QueryTemplate queryTemplate, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) {
        return this.doCreateStatementResultIterator(connection, statement, queryTemplate, autoGeneratedKeyStrategy, this.resultSetHandler);
    }

    protected StatementResultIterator doCreateStatementResultIterator(DbConnection connection, Statement statement, QueryTemplate queryTemplate, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy, ResultSetHandler resultSetHandler) {
        this.checkStreamingSupport(connection, statement);
        return new StatementResultIterator(connection, statement, queryTemplate, autoGeneratedKeyStrategy, resultSetHandler);
    }

    private void checkStreamingSupport(DbConnection connection, Statement statement) {
        try {
            if (statement instanceof CallableStatement && !connection.getMetaData().supportsMultipleOpenResults()) {
                throw new IllegalArgumentException("Database does not supports streaming on stored procedures");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

