/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor;

import org.apache.commons.logging.Log;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.processor.LoggerMessageProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class LoggerMessageProcessorTestCase
extends AbstractMuleTestCase {
    @Test
    public void logNullEvent() {
        this.verifyNullEventByLevel("TRACE");
        this.verifyNullEventByLevel("DEBUG");
        this.verifyNullEventByLevel("INFO");
        this.verifyNullEventByLevel("WARN");
        this.verifyNullEventByLevel("ERROR");
    }

    @Test
    public void logMuleEvent() {
        this.verifyMuleEventByLevel("TRACE");
        this.verifyMuleEventByLevel("DEBUG");
        this.verifyMuleEventByLevel("INFO");
        this.verifyMuleEventByLevel("WARN");
        this.verifyMuleEventByLevel("ERROR");
    }

    @Test
    public void logWithMessage() {
        this.verifyLoggerMessageByLevel("TRACE");
        this.verifyLoggerMessageByLevel("DEBUG");
        this.verifyLoggerMessageByLevel("INFO");
        this.verifyLoggerMessageByLevel("WARN");
        this.verifyLoggerMessageByLevel("ERROR");
    }

    private void verifyLogCall(LoggerMessageProcessor loggerMessageProcessor, String logLevel, String enabledLevel, MuleEvent muleEvent, Object objectToLog) {
        Mockito.when((Object)loggerMessageProcessor.logger.isTraceEnabled()).thenReturn((Object)"TRACE".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isDebugEnabled()).thenReturn((Object)"DEBUG".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isInfoEnabled()).thenReturn((Object)"INFO".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isWarnEnabled()).thenReturn((Object)"WARN".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isErrorEnabled()).thenReturn((Object)"ERROR".equals(enabledLevel));
        loggerMessageProcessor.log(muleEvent);
        ((Log)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("TRACE".equals(enabledLevel) ? 1 : 0)))).trace(objectToLog);
        ((Log)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("DEBUG".equals(enabledLevel) ? 1 : 0)))).debug(objectToLog);
        ((Log)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("INFO".equals(enabledLevel) ? 1 : 0)))).info(objectToLog);
        ((Log)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("WARN".equals(enabledLevel) ? 1 : 0)))).warn(objectToLog);
        ((Log)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("ERROR".equals(enabledLevel) ? 1 : 0)))).error(objectToLog);
    }

    private void verifyExpressionEvaluation(LoggerMessageProcessor loggerMessageProcessor, String level, String enabledLevel, MuleEvent muleEvent, VerificationMode timesEvaluateExpression) {
        Mockito.when((Object)loggerMessageProcessor.logger.isTraceEnabled()).thenReturn((Object)"TRACE".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isDebugEnabled()).thenReturn((Object)"DEBUG".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isInfoEnabled()).thenReturn((Object)"INFO".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isWarnEnabled()).thenReturn((Object)"WARN".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isErrorEnabled()).thenReturn((Object)"ERROR".equals(enabledLevel));
        loggerMessageProcessor.expressionManager = this.buildExpressionManager();
        loggerMessageProcessor.log(muleEvent);
        ((ExpressionManager)Mockito.verify((Object)loggerMessageProcessor.expressionManager, (VerificationMode)timesEvaluateExpression)).parse("some expression", muleEvent);
    }

    private void verifyNullEventByLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, level, null, null);
        loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, "not" + level, null, null);
    }

    private void verifyMuleEventByLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        MuleEvent muleEvent = this.buildMuleEvent();
        this.verifyLogCall(loggerMessageProcessor, level, level, muleEvent, muleEvent.getMessage());
        loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, "not" + level, muleEvent, muleEvent.getMessage());
    }

    private void verifyLoggerMessageByLevel(String level) {
        MuleEvent muleEvent = this.buildMuleEvent();
        this.verifyLogCall(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, level, muleEvent, "text to log");
        this.verifyLogCall(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, "not" + level, muleEvent, "text to log");
        this.verifyExpressionEvaluation(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, level, muleEvent, Mockito.times((int)1));
        this.verifyExpressionEvaluation(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, "not" + level, muleEvent, Mockito.never());
    }

    private Log buildMockLogger() {
        Log mockLogger = (Log)Mockito.mock(Log.class);
        ((Log)Mockito.doNothing().when((Object)mockLogger)).error(Matchers.any());
        ((Log)Mockito.doNothing().when((Object)mockLogger)).warn(Matchers.any());
        ((Log)Mockito.doNothing().when((Object)mockLogger)).info(Matchers.any());
        ((Log)Mockito.doNothing().when((Object)mockLogger)).debug(Matchers.any());
        ((Log)Mockito.doNothing().when((Object)mockLogger)).trace(Matchers.any());
        Mockito.when((Object)mockLogger.isErrorEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isWarnEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isInfoEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isDebugEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isTraceEnabled()).thenReturn((Object)true);
        return mockLogger;
    }

    private LoggerMessageProcessor buildLoggerMessageProcessorWithLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = new LoggerMessageProcessor();
        loggerMessageProcessor.initLogger();
        loggerMessageProcessor.logger = this.buildMockLogger();
        loggerMessageProcessor.setLevel(level);
        return loggerMessageProcessor;
    }

    private LoggerMessageProcessor buildLoggerMessageProcessorForExpressionEvaluation(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        loggerMessageProcessor.expressionManager = this.buildExpressionManager();
        loggerMessageProcessor.setMessage("some expression");
        return loggerMessageProcessor;
    }

    private MuleEvent buildMuleEvent() {
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.toString()).thenReturn((Object)"text to log");
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        return event;
    }

    private ExpressionManager buildExpressionManager() {
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        Mockito.when((Object)expressionManager.parse(Matchers.anyString(), (MuleEvent)Matchers.any(MuleEvent.class))).thenReturn((Object)"text to log");
        return expressionManager;
    }
}

