/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.URIBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class URIBuilderTestCase
extends AbstractMuleTestCase {
    private static final Map<String, String> queries = new HashMap<String, String>();
    protected MuleContext unusedMuleContext = null;

    @Test
    public void testAddressForProtocol() {
        URIBuilder uri = new URIBuilder(this.unusedMuleContext);
        uri.setProtocol("foo");
        uri.setAddress("foo://bar");
        Assert.assertEquals((Object)"foo://bar", (Object)uri.toString());
    }

    @Test
    public void testAddressForMeta() {
        URIBuilder uri = new URIBuilder(this.unusedMuleContext);
        uri.setMeta("foo");
        uri.setAddress("baz://bar");
        Assert.assertEquals((Object)"foo:baz://bar", (Object)uri.toString());
    }

    @Test
    public void testQueriesWithAddress() {
        URIBuilder uri = new URIBuilder(this.unusedMuleContext);
        uri.setAddress("foo://bar");
        uri.setQueryMap(queries);
        Assert.assertEquals((Object)"foo://bar?aname=avalue&bname=bvalue", (Object)uri.toString());
    }

    @Test
    public void testLiteralQueries() {
        URIBuilder uri1 = new URIBuilder(this.unusedMuleContext);
        uri1.setAddress("foo://bar?cname=cvalue&aname=anothervalue");
        uri1.setQueryMap(queries);
        Assert.assertEquals((Object)"foo://bar?cname=cvalue&aname=avalue&bname=bvalue", (Object)uri1.toString());
        URIBuilder uri2 = new URIBuilder(this.unusedMuleContext);
        uri2.setQueryMap(queries);
        uri2.setAddress("foo://bar?cname=cvalue&aname=anothervalue");
        Assert.assertEquals((Object)"foo://bar?cname=cvalue&aname=avalue&bname=bvalue", (Object)uri2.toString());
    }

    @Test
    public void testNullQueries() {
        URIBuilder uri1 = new URIBuilder(this.unusedMuleContext);
        uri1.setAddress("foo://bar?cname&aname");
        uri1.setQueryMap(queries);
        Assert.assertEquals((Object)"foo://bar?cname&aname=avalue&bname=bvalue", (Object)uri1.toString());
    }

    @Test
    public void testFromString() {
        URIBuilder uri = new URIBuilder("test://bar", this.unusedMuleContext);
        EndpointURI endpointURI = uri.getEndpoint();
        Assert.assertEquals((Object)"test://bar", (Object)endpointURI.getUri().toString());
        Assert.assertEquals((Object)"test", (Object)endpointURI.getSchemeMetaInfo());
        uri = new URIBuilder("meta:test://bar", this.unusedMuleContext);
        endpointURI = uri.getEndpoint();
        Assert.assertEquals((Object)"test://bar", (Object)endpointURI.getUri().toString());
        Assert.assertEquals((Object)"meta", (Object)endpointURI.getSchemeMetaInfo());
    }

    @Test
    public void testMultiValueParam() {
        URIBuilder uri = new URIBuilder("test://bar?aname=avalue&aname=bvalue&aname=cvalue", this.unusedMuleContext);
        EndpointURI endpointURI = uri.getEndpoint();
        Assert.assertEquals((Object)"test://bar?aname=avalue&aname=bvalue&aname=cvalue", (Object)endpointURI.getUri().toString());
        HashMap<String, String> tq = new HashMap<String, String>();
        tq.put("aname", "zvalue");
        tq.put("dname", "dvalue");
        uri = new URIBuilder("test://bar?aname=avalue&aname=bvalue&aname=cvalue", this.unusedMuleContext);
        uri.setQueryMap(tq);
        endpointURI = uri.getEndpoint();
        Assert.assertEquals((Object)"test://bar?aname=zvalue&aname=bvalue&aname=cvalue&dname=dvalue", (Object)endpointURI.getUri().toString());
    }

    @Test
    public void testConstructAddress() {
        URIBuilder uri = this.createURIBuilder("localhost", 8080, "http", "/test");
        String result = uri.getEncodedConstructor();
        Assert.assertEquals((Object)"http://localhost:8080/test", (Object)result);
    }

    @Test
    public void testConstructAddressWithRootTrailingSlashInPath() {
        URIBuilder uri = this.createURIBuilder("localhost", 8080, "http", "/");
        String result = uri.getEncodedConstructor();
        Assert.assertEquals((Object)"http://localhost:8080", (Object)result);
    }

    @Test
    public void testConstructAddressWithRootTrailingSlashInAddress() {
        URIBuilder uri = new URIBuilder();
        uri.setAddress("http://localhost:8080/");
        String result = uri.getEncodedConstructor();
        Assert.assertEquals((Object)"http://localhost:8080", (Object)result);
    }

    @Test
    public void testConstructAddressWithTrailingSlashInPath() {
        URIBuilder uri = this.createURIBuilder("localhost", 8080, "http", "/test/");
        String result = uri.getEncodedConstructor();
        Assert.assertEquals((Object)"http://localhost:8080/test/", (Object)result);
    }

    @Test
    public void testConstructAddressWithTrailingSlashInAddress() {
        URIBuilder uri = new URIBuilder();
        uri.setAddress("http://localhost:8080/test/");
        String result = uri.getEncodedConstructor();
        Assert.assertEquals((Object)"http://localhost:8080/test/", (Object)result);
    }

    @Test
    public void testConstructAddressWithParamsInRootPath() {
        String address = "http://localhost:8080/?key1=value1";
        URIBuilder uri = new URIBuilder();
        uri.setAddress(address);
        String result = uri.getEncodedConstructor();
        Assert.assertEquals((Object)address, (Object)result);
    }

    private URIBuilder createURIBuilder(String host, int port, String protocol, String path) {
        URIBuilder builder = new URIBuilder();
        builder.setHost(host);
        builder.setPort(port);
        builder.setProtocol(protocol);
        builder.setPath(path);
        return builder;
    }

    static {
        queries.put("aname", "avalue");
        queries.put("bname", "bvalue");
    }
}

