/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.DefaultMuleException;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.util.StreamCloserService;
import org.mule.exception.CatchMessagingExceptionStrategy;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.TransactionCoordination;

@RunWith(value=MockitoJUnitRunner.class)
public class CatchMessagingExceptionStrategyTestCase {
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    @Mock
    private Exception mockException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleMessage mockMuleMessage;
    @Mock
    private StreamCloserService mockStreamCloserService;
    @Spy
    private TestTransaction mockTransaction = new TestTransaction(this.mockMuleContext);
    @Spy
    private TestTransaction mockXaTransaction = new TestTransaction(this.mockMuleContext, true);
    private CatchMessagingExceptionStrategy catchMessagingExceptionStrategy;

    @Before
    public void before() throws Exception {
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
        this.catchMessagingExceptionStrategy = new CatchMessagingExceptionStrategy();
        this.catchMessagingExceptionStrategy.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleContext.getStreamCloserService()).thenReturn((Object)this.mockStreamCloserService);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.mockMuleMessage);
    }

    @Test
    public void testHandleExceptionWithNoConfig() throws Exception {
        this.configureXaTransactionAndSingleResourceTransaction();
        MuleEvent resultEvent = this.catchMessagingExceptionStrategy.handleException(this.mockException, this.mockMuleEvent);
        Assert.assertThat((Object)resultEvent, (Matcher)Is.is((Object)resultEvent));
        ((MuleMessage)Mockito.verify((Object)this.mockMuleMessage, (VerificationMode)VerificationModeFactory.times((int)2))).setExceptionPayload((ExceptionPayload)Matchers.any(ExceptionPayload.class));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((StreamCloserService)Mockito.verify((Object)this.mockStreamCloserService)).closeStream(Matchers.any(Object.class));
    }

    @Test
    public void testHandleExceptionWithConfiguredMessageProcessors() throws Exception {
        this.catchMessagingExceptionStrategy.setMessageProcessors(Arrays.asList(this.createSetStringMessageProcessor("A"), this.createSetStringMessageProcessor("B")));
        this.catchMessagingExceptionStrategy.initialise();
        this.catchMessagingExceptionStrategy.handleException(this.mockException, this.mockMuleEvent);
        ((MuleMessage)Mockito.verify((Object)this.mockMuleEvent.getMessage(), (VerificationMode)VerificationModeFactory.times((int)1))).setPayload((Object)"A");
        ((MuleMessage)Mockito.verify((Object)this.mockMuleEvent.getMessage(), (VerificationMode)VerificationModeFactory.times((int)1))).setPayload((Object)"B");
    }

    @Test
    public void testHandleExceptionWithMessageProcessorsChangingEvent() throws Exception {
        MuleEvent lastEventCreated = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        this.catchMessagingExceptionStrategy.setMessageProcessors(Arrays.asList(this.createChagingEventMessageProcessor((MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get())), this.createChagingEventMessageProcessor(lastEventCreated)));
        this.catchMessagingExceptionStrategy.initialise();
        MuleEvent exceptionHandlingResult = this.catchMessagingExceptionStrategy.handleException(this.mockException, this.mockMuleEvent);
        Assert.assertThat((Object)exceptionHandlingResult, (Matcher)Is.is((Object)lastEventCreated));
    }

    @Test
    public void testMessageToStringNotCalledOnFailure() throws Exception {
        MuleEvent lastEventCreated = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        this.catchMessagingExceptionStrategy.setMessageProcessors(Arrays.asList(this.createFailingEventMessageProcessor((MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get())), this.createFailingEventMessageProcessor(lastEventCreated)));
        this.catchMessagingExceptionStrategy.initialise();
        Mockito.when((Object)this.mockMuleEvent.getMessage().toString()).thenThrow(new Throwable[]{new RuntimeException("MuleMessage.toString() should not be called")});
        MuleEvent exceptionHandlingResult = this.catchMessagingExceptionStrategy.handleException(this.mockException, this.mockMuleEvent);
    }

    private MessageProcessor createChagingEventMessageProcessor(final MuleEvent lastEventCreated) {
        return new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return lastEventCreated;
            }
        };
    }

    private MessageProcessor createFailingEventMessageProcessor(MuleEvent lastEventCreated) {
        return new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                throw new DefaultMuleException((Throwable)CatchMessagingExceptionStrategyTestCase.this.mockException);
            }
        };
    }

    private MessageProcessor createSetStringMessageProcessor(final String appendText) {
        return new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)appendText);
                return event;
            }
        };
    }

    private void configureXaTransactionAndSingleResourceTransaction() throws TransactionException {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockXaTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
    }
}

