/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.execution.ExceptionToMessagingExceptionExecutionInterceptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExceptionToMessagingExceptionExecutionInterceptorTestCase
extends AbstractMuleTestCase {
    @Mock
    private MessageProcessor mockMessageProcessor;
    @Mock
    private MuleEvent mockMuleEvent;
    @Mock
    private MuleEvent mockResultMuleEvent;
    @Mock
    private MessagingException mockMessagingException;
    @Mock
    private MuleException mockMuleException;
    private ExceptionToMessagingExceptionExecutionInterceptor cut = new ExceptionToMessagingExceptionExecutionInterceptor();

    @Test
    public void testExecutionSuccessfully() throws MuleException {
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        MuleEvent result = this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.mockResultMuleEvent));
    }

    @Test
    public void testMessageExceptionThrown() throws MuleException {
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{this.mockMessagingException});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
        }
    }

    @Test
    public void testCheckedExceptionThrown() throws MuleException {
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{this.mockMuleException});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)((MuleException)e.getCause())), (Matcher)Is.is((Object)((Object)this.mockMuleException)));
        }
    }

    @Test
    public void testRuntimeExceptionThrown() throws MuleException {
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{runtimeException});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((RuntimeException)e.getCause()), (Matcher)Is.is((Object)runtimeException));
        }
    }

    @Test
    public void testErrorThrown() throws MuleException {
        Error error = new Error();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{error});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Error)e.getCause()), (Matcher)Is.is((Object)error));
        }
    }
}

