/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.concurrent.Executors;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.CompletionHandler;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.processor.AbstractNonBlockingMessageProcessor;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.Latch;

public class SensingNullMessageProcessor
extends AbstractNonBlockingMessageProcessor
implements MessageProcessor {
    public MuleEvent event;
    public Latch latch = new Latch();
    public Thread thread;
    protected InternalMessageSource source = new InternalMessageSource();
    private long waitTime = 0L;
    private boolean enableNonBlocking = true;
    private String appendString;

    public SensingNullMessageProcessor() {
    }

    public SensingNullMessageProcessor(String appendString) {
        this.appendString = appendString;
    }

    protected void processNonBlocking(final MuleEvent event, CompletionHandler completionHandler) throws MuleException {
        this.sense(event);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MuleEvent eventToProcess = event;
                    if (StringUtils.isNotEmpty((String)SensingNullMessageProcessor.this.appendString)) {
                        eventToProcess = SensingNullMessageProcessor.this.append(eventToProcess);
                    }
                    event.getReplyToHandler().processReplyTo(eventToProcess, null, null);
                    SensingNullMessageProcessor.this.latch.countDown();
                }
                catch (MuleException e) {
                    event.getReplyToHandler().processExceptionReplyTo(new MessagingException(event, (Throwable)e), null);
                }
            }
        });
    }

    private void sense(MuleEvent event) {
        this.sleepIfNeeded();
        this.event = event;
        this.thread = Thread.currentThread();
    }

    protected MuleEvent processBlocking(MuleEvent event) throws MuleException {
        this.sense(event);
        if (StringUtils.isNotEmpty((String)this.appendString)) {
            event = this.append(event);
        }
        this.latch.countDown();
        if (this.source.listener != null) {
            return this.source.listener.process(event);
        }
        if (event.getExchangePattern().hasResponse()) {
            return event;
        }
        return VoidMuleEvent.getInstance();
    }

    public boolean isNonBlocking(MuleEvent event) {
        return super.isNonBlocking(event) && this.enableNonBlocking;
    }

    private MuleEvent append(MuleEvent event) {
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(event.getMessage().getPayload() + this.appendString), event.getMuleContext()), event);
    }

    private void sleepIfNeeded() {
        if (this.waitTime > 0L) {
            try {
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void clear() {
        this.event = null;
    }

    public MessageSource getMessageSource() {
        return this.source;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    class InternalMessageSource
    implements MessageSource {
        MessageProcessor listener;

        InternalMessageSource() {
        }

        public void setListener(MessageProcessor listener) {
            this.listener = listener;
        }

        public String toString() {
            return ObjectUtils.toString((Object)this);
        }
    }
}

