/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.registry.ResolverException;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.CompositeConverter;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.graph.TransformationLengthConverterFilter;

@SmallTest
public class ShortestTransformationLengthTransformerFilterTestCase
extends AbstractMuleTestCase {
    private static final DataType XML_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"XML_DATA_TYPE");
    private static final DataType JSON_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"JSON_DATA_TYPE");
    private static final DataType STRING_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"STRING_DATA_TYPE");
    private static final DataType UNUSED_DATA_TYPE = null;
    private TransformationLengthConverterFilter filter = new TransformationLengthConverterFilter();

    @Test
    public void filtersEmptyList() throws ResolverException {
        ArrayList availableConverters = new ArrayList();
        List converters = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void filtersEqualLength() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToString);
        availableConverters.add(xmlToJson);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        Assert.assertEquals((int)2, (int)transformers.size());
        Assert.assertTrue((boolean)transformers.contains(xmlToString));
        Assert.assertTrue((boolean)transformers.contains(xmlToJson));
    }

    @Test
    public void filtersDifferentLengthWithBetterTrasnformerFist() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        ArrayList<Object> availableConverters = new ArrayList<Object>();
        availableConverters.add(xmlToString);
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{xmlToString, stringToJson});
        availableConverters.add(compositeConverter);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        Assert.assertEquals((int)1, (int)transformers.size());
        Assert.assertEquals((Object)xmlToString, transformers.get(0));
    }

    @Test
    public void filtersDifferentLengthWithBetterTransformerLast() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        ArrayList<Object> availableConverters = new ArrayList<Object>();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{xmlToString, stringToJson});
        availableConverters.add(compositeConverter);
        availableConverters.add(xmlToString);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        Assert.assertEquals((int)1, (int)transformers.size());
        Assert.assertEquals((Object)xmlToString, transformers.get(0));
    }
}

