/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.extension.resources.ResourcesGenerator;
import org.mule.extension.resources.spi.GenerableResourceContributor;
import org.mule.module.extension.internal.capability.xml.schema.SchemaGenerator;
import org.mule.module.extension.internal.config.ExtensionsNamespaceHandler;

public class SpringBundleResourceContributor
implements GenerableResourceContributor {
    public void contribute(Extension extension, ResourcesGenerator resourcesGenerator) {
        Set capabilities = extension.getCapabilities(XmlCapability.class);
        if (CollectionUtils.isEmpty((Collection)capabilities)) {
            return;
        }
        XmlCapability capability = (XmlCapability)capabilities.iterator().next();
        this.generateSchema(extension, capability, resourcesGenerator);
        this.generateSpringBundle(extension, capability, resourcesGenerator);
    }

    private void generateSchema(Extension extension, XmlCapability capability, ResourcesGenerator resourcesGenerator) {
        String schema = new SchemaGenerator().generate(extension, capability);
        resourcesGenerator.getOrCreateResource(this.getXsdFileName(extension)).getContentBuilder().append(schema);
    }

    private void generateSpringBundle(Extension extension, XmlCapability capability, ResourcesGenerator resourcesGenerator) {
        this.writeSpringHandlerBundle(capability, resourcesGenerator);
        this.writeSpringSchemaBundle(extension, capability, resourcesGenerator);
    }

    private void writeSpringHandlerBundle(XmlCapability capability, ResourcesGenerator resourcesGenerator) {
        String content = String.format("%s=%s", capability.getSchemaLocation(), ExtensionsNamespaceHandler.class.getName());
        resourcesGenerator.getOrCreateResource("spring.handlers").getContentBuilder().append(this.springBundleScape(content));
    }

    private void writeSpringSchemaBundle(Extension extension, XmlCapability capability, ResourcesGenerator resourcesGenerator) {
        StringBuilder builder = resourcesGenerator.getOrCreateResource("spring.schemas").getContentBuilder();
        builder.append(this.getSpringSchemaBundle(extension, capability, capability.getSchemaVersion()));
        builder.append(this.getSpringSchemaBundle(extension, capability, "current"));
    }

    private String getSpringSchemaBundle(Extension extension, XmlCapability capability, String version) {
        String filename = this.getXsdFileName(extension);
        return this.springBundleScape(String.format("%s/%s/%s=META-INF/%s\n", capability.getSchemaLocation(), version, filename, filename));
    }

    private String getXsdFileName(Extension extension) {
        return String.format("mule-%s%s", extension.getName(), ".xsd");
    }

    private String springBundleScape(String content) {
        return content.replaceAll(":", "\\\\:");
    }
}

