/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.config.ExceptionHelper;
import org.mule.execution.RequestResponseFlowProcessingPhaseTemplate;
import org.mule.execution.ThrottlingPhaseTemplate;
import org.mule.module.http.internal.listener.HttpThrottlingHeadersMapBuilder;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractTransportMessageProcessTemplate;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.servlet.ServletResponseWriter;

public class JettyMessageProcessTemplate
extends AbstractTransportMessageProcessTemplate
implements RequestResponseFlowProcessingPhaseTemplate,
ThrottlingPhaseTemplate {
    private final HttpThrottlingHeadersMapBuilder httpThrottlingHeadersMapBuilder = new HttpThrottlingHeadersMapBuilder();
    private final ServletResponseWriter servletResponseWriter = new ServletResponseWriter();
    private final HttpServletRequest request;
    private final HttpServletResponse servletResponse;
    private final MuleContext muleContext;
    private boolean failureResponseSentToClient;

    public JettyMessageProcessTemplate(HttpServletRequest request, HttpServletResponse response, AbstractMessageReceiver messageReceiver, MuleContext muleContext) {
        super(messageReceiver);
        this.request = request;
        this.servletResponse = response;
        this.muleContext = muleContext;
    }

    public Object acquireMessage() throws MuleException {
        return this.request;
    }

    protected MuleMessage createMessageFromSource(Object message) throws MuleException {
        MuleMessage muleMessage = super.createMessageFromSource(message);
        String contextPath = HttpConnector.normalizeUrl((String)this.getInboundEndpoint().getEndpointURI().getPath());
        muleMessage.setProperty("http.context.path", (Object)contextPath, PropertyScope.INBOUND);
        return muleMessage;
    }

    public void discardMessageOnThrottlingExceeded() throws MuleException {
        try {
            this.servletResponseWriter.writeNonHtmlErrorResponse(this.servletResponse, 429, "API calls exceeded", this.httpThrottlingHeadersMapBuilder.build());
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    public void setThrottlingPolicyStatistics(long remainingRequestInCurrentPeriod, long maximumRequestAllowedPerPeriod, long timeUntilNextPeriodInMillis) {
        this.httpThrottlingHeadersMapBuilder.setThrottlingPolicyStatistics(remainingRequestInCurrentPeriod, maximumRequestAllowedPerPeriod, timeUntilNextPeriodInMillis);
    }

    public void sendResponseToClient(MuleEvent muleEvent) throws MuleException {
        try {
            MuleMessage message = muleEvent.getMessage();
            if (message == null) {
                this.servletResponseWriter.writeEmptyResponse(this.servletResponse, this.httpThrottlingHeadersMapBuilder.build());
            } else {
                this.servletResponseWriter.writeResponse(this.servletResponse, message, this.httpThrottlingHeadersMapBuilder.build());
            }
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    public void sendFailureResponseToClient(MessagingException messagingException) throws MuleException {
        try {
            int statusCode = this.retrieveStatusCode(messagingException);
            this.servletResponseWriter.writeErrorResponse(this.servletResponse, messagingException.getEvent().getMessage(), statusCode, messagingException.getMessage(), this.httpThrottlingHeadersMapBuilder.build());
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
        this.failureResponseSentToClient = true;
    }

    public void afterFailureProcessingFlow(MuleException exception) throws MuleException {
        block3: {
            if (!this.failureResponseSentToClient) {
                String temp = ExceptionHelper.getErrorMapping((String)this.getConnector().getProtocol(), ((Object)((Object)exception)).getClass(), (MuleContext)this.getMuleContext());
                int httpStatus = Integer.valueOf(temp);
                try {
                    this.servletResponseWriter.writeErrorResponse(this.servletResponse, httpStatus, exception.getMessage(), new HashMap());
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Exception sending Jetty HTTP response after error: " + e.getMessage()));
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug((Object)e);
                }
            }
        }
    }

    private int retrieveStatusCode(MessagingException messagingException) {
        Object statusCodeValue = messagingException.getEvent().getMessage().getOutboundProperty("http.status");
        if (statusCodeValue != null) {
            if (statusCodeValue instanceof Number) {
                return ((Number)statusCodeValue).intValue();
            }
            return Integer.valueOf((String)statusCodeValue);
        }
        return Integer.valueOf(ExceptionHelper.getErrorMapping((String)"http", messagingException.getClass(), (MuleContext)this.muleContext));
    }

    protected ServletResponseWriter getServletResponseWriter() {
        return this.servletResponseWriter;
    }

    protected HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }
}

