/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.List;
import java.util.Map;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessTemplate;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.TransportMessageProcessContext;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageProcessTemplate;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.HttpServerConnection;
import org.mule.util.MapUtils;

public class HttpMessageReceiver
extends AbstractMessageReceiver {
    public HttpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    protected void doConnect() throws ConnectException {
        ((HttpConnector)this.connector).connect(this.endpoint.getEndpointURI());
    }

    protected void doDisconnect() throws Exception {
        ((HttpConnector)this.connector).disconnect(this.endpoint.getEndpointURI());
    }

    HttpMessageProcessTemplate createMessageProcessTemplate(HttpServerConnection httpServerConnection) {
        return new HttpMessageProcessTemplate(this, httpServerConnection);
    }

    MessageProcessContext createMessageProcessContext() {
        return new TransportMessageProcessContext((MessageReceiver)this, this.getWorkManager());
    }

    void processRequest(HttpServerConnection httpServerConnection) throws InterruptedException, MuleException {
        HttpMessageProcessTemplate messageProcessTemplate = this.createMessageProcessTemplate(httpServerConnection);
        MessageProcessContext messageProcessContext = this.createMessageProcessContext();
        this.processMessage((MessageProcessTemplate)messageProcessTemplate, messageProcessContext);
        messageProcessTemplate.awaitTermination();
    }

    protected String processRelativePath(String contextPath, String path) {
        String relativePath = path.substring(contextPath.length());
        if (relativePath.startsWith("/")) {
            return relativePath.substring(1);
        }
        return relativePath;
    }

    protected void initializeMessageFactory() throws InitialisationException {
        try {
            HttpMuleMessageFactory factory = (HttpMuleMessageFactory)super.createMuleMessageFactory();
            boolean enableCookies = MapUtils.getBooleanValue((Map)this.endpoint.getProperties(), (Object)"enableCookies", (boolean)((HttpConnector)this.connector).isEnableCookies());
            factory.setEnableCookies(enableCookies);
            String cookieSpec = MapUtils.getString((Map)this.endpoint.getProperties(), (Object)"cookieSpec", (String)((HttpConnector)this.connector).getCookieSpec());
            factory.setCookieSpec(cookieSpec);
            factory.setExchangePattern(this.endpoint.getExchangePattern());
            this.muleMessageFactory = factory;
        }
        catch (CreateException ce) {
            Message message = MessageFactory.createStaticMessage((String)ce.getMessage());
            throw new InitialisationException(message, (Throwable)ce, (Initialisable)this);
        }
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message request '" + message.getInboundProperty("http.request") + "' is being rejected since it does not match the filter on this endpoint: " + this.endpoint));
        }
        message.setOutboundProperty("http.status", (Object)String.valueOf(406));
        return message;
    }

    public List<Transformer> getResponseTransportTransformers() {
        return this.defaultResponseTransformers;
    }

    public static class FailureProcessingRequestException
    extends RuntimeException {
    }

    public static class EmptyRequestException
    extends RuntimeException {
    }
}

