/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.DataProvider;
import org.drools.spi.PropagationContext;
import org.drools.util.LeftTupleList;

public class FromNode
extends LeftTupleSource
implements LeftTupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private DataProvider dataProvider;
    private LeftTupleSource tupleSource;
    private AlphaNodeFieldConstraint[] alphaConstraints;
    private BetaConstraints betaConstraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    protected boolean tupleMemoryEnabled;

    public FromNode() {
    }

    public FromNode(int id, DataProvider dataProvider, LeftTupleSource tupleSource, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder, boolean tupleMemoryEnabled, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.dataProvider = dataProvider;
        this.tupleSource = tupleSource;
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.dataProvider = (DataProvider)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.alphaConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.betaConstraints = (BetaConstraints)in.readObject();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.dataProvider);
        out.writeObject(this.tupleSource);
        out.writeObject(this.alphaConstraints);
        out.writeObject(this.betaConstraints);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeBoolean(this.tupleMemoryEnabled);
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        if (this.tupleMemoryEnabled) {
            memory.betaMemory.getLeftTupleMemory().add(leftTuple);
        }
        if (this.sink.size() == 0) {
            return;
        }
        this.evaluateAndPropagate(leftTuple, context, workingMemory, memory);
    }

    private void evaluateAndPropagate(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, FromMemory memory) {
        this.betaConstraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        Iterator it = this.dataProvider.getResults(leftTuple, workingMemory, context, memory.providerContext);
        while (it.hasNext()) {
            Object object = it.next();
            InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(object, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), object), workingMemory);
            RightTuple rightTuple = new RightTuple(handle, null);
            boolean isAllowed = true;
            if (this.alphaConstraints != null) {
                int length = this.alphaConstraints.length;
                for (int i = 0; i < length; ++i) {
                    if (this.alphaConstraints[i].isAllowed(handle, workingMemory, memory.alphaContexts[i])) continue;
                    isAllowed = false;
                    break;
                }
            }
            if (isAllowed && this.betaConstraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle)) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, context, workingMemory, this.tupleMemoryEnabled);
                continue;
            }
            workingMemory.getFactHandleFactory().destroyFactHandle(handle);
        }
        this.betaConstraints.resetTuple(memory.betaMemory.getContext());
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getLeftTupleMemory().remove(leftTuple);
        this.sink.propagateRetractLeftTupleDestroyRightTuple(leftTuple, context, workingMemory);
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        context.visitTupleSource(this);
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                FromMemory memory = (FromMemory)workingMemories[i].getNodeMemory(this);
                org.drools.util.Iterator it = memory.betaMemory.getLeftTupleMemory().iterator();
                LeftTuple leftTuple = (LeftTuple)it.next();
                while (leftTuple != null) {
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = (LeftTuple)it.next();
                }
                workingMemories[i].clearNodeMemory(this);
            }
        }
        if (!context.alreadyVisited(this.tupleSource)) {
            this.tupleSource.remove(context, builder, this, workingMemories);
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        org.drools.util.Iterator tupleIter = memory.betaMemory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            this.evaluateAndPropagate(leftTuple, context, workingMemory, memory);
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    public Object createMemory(RuleBaseConfiguration config) {
        BetaMemory beta = new BetaMemory(new LeftTupleList(), null, this.betaConstraints.createContext());
        return new FromMemory(beta, this.dataProvider.createContext(), this.alphaConstraints);
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public short getType() {
        return 4;
    }

    public static class FromMemory
    implements Serializable {
        private static final long serialVersionUID = -5802345705144095216L;
        public BetaMemory betaMemory;
        public Object providerContext;
        public ContextEntry[] alphaContexts;

        public FromMemory(BetaMemory betaMemory, Object providerContext, AlphaNodeFieldConstraint[] constraints) {
            this.betaMemory = betaMemory;
            this.providerContext = providerContext;
            this.alphaContexts = new ContextEntry[constraints.length];
            for (int i = 0; i < constraints.length; ++i) {
                this.alphaContexts[i] = constraints[i].createContextEntry();
            }
        }
    }
}

