/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.artifact;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import org.mule.module.launcher.artifact.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceReleaser
implements ResourceReleaser {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void release() {
        this.deregisterJdbcDrivers();
    }

    private void deregisterJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                this.logger.debug("Deregistering driver: {}", driver.getClass());
                DriverManager.deregisterDriver(driver);
            }
            catch (Exception e) {
                this.logger.warn(String.format("Can not deregister driver %s. This can cause a memory leak.", driver.getClass()), (Throwable)e);
            }
        }
    }
}

