/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.domain;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.domain.DefaultMuleDomain;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.launcher.domain.DomainClassLoaderRepository;
import org.mule.module.launcher.domain.DomainFactory;
import org.mule.module.launcher.domain.DomainWrapper;
import org.mule.module.reboot.MuleContainerBootstrapUtils;

public class DefaultDomainFactory
implements DomainFactory {
    private final DomainClassLoaderRepository domainClassLoaderRepository;
    private final Map<String, Domain> domains = new HashMap<String, Domain>();
    protected DeploymentListener deploymentListener;

    public DefaultDomainFactory(DomainClassLoaderRepository domainClassLoaderRepository) {
        this.domainClassLoaderRepository = domainClassLoaderRepository;
    }

    public void setDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    @Override
    public Domain createDefaultDomain() throws IOException {
        return this.createArtifact("default");
    }

    @Override
    public Domain createArtifact(String artifactName) throws IOException {
        if (this.domains.containsKey(artifactName)) {
            return this.domains.get(artifactName);
        }
        if (artifactName.contains(" ")) {
            throw new IllegalArgumentException("Mule application name may not contain spaces: " + artifactName);
        }
        DefaultMuleDomain defaultMuleDomain = new DefaultMuleDomain(this.domainClassLoaderRepository, artifactName);
        defaultMuleDomain.setDeploymentListener(this.deploymentListener);
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domains.put(artifactName, domainWrapper);
        return domainWrapper;
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleDomainsDir();
    }

    public void dispose(Domain domain) {
        this.domains.remove(domain.getArtifactName());
    }
}

