/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.log4j2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Disposable;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.log4j2.ArtifactAwareContextSelector;

final class LoggerContextCache
implements Disposable {
    private static final long DEFAULT_DISPOSE_DELAY_IN_MILLIS = 15000L;
    private final ArtifactAwareContextSelector artifactAwareContextSelector;
    private final Cache<Integer, LoggerContext> activeContexts;
    private final Cache<Integer, LoggerContext> disposedContexts;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private Long disposeDelayInMillis;

    LoggerContextCache(ArtifactAwareContextSelector artifactAwareContextSelector) {
        this.acquireContextDisposeDelay();
        this.artifactAwareContextSelector = artifactAwareContextSelector;
        this.activeContexts = CacheBuilder.newBuilder().build();
        this.disposedContexts = CacheBuilder.newBuilder().expireAfterWrite(this.disposeDelayInMillis.longValue(), TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<Integer, LoggerContext>(){

            public void onRemoval(RemovalNotification<Integer, LoggerContext> notification) {
                LoggerContextCache.this.stop((LoggerContext)notification.getValue());
                LoggerContextCache.this.activeContexts.invalidate(notification.getKey());
            }
        }).build();
    }

    private void stop(LoggerContext loggerContext) {
        if (loggerContext != null && !loggerContext.isStopping() && !loggerContext.isStopped()) {
            loggerContext.stop();
        }
    }

    private void acquireContextDisposeDelay() {
        try {
            this.disposeDelayInMillis = Long.valueOf(System.getProperty("mule.log.context.dispose.delay.millis"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.disposeDelayInMillis == null) {
            this.disposeDelayInMillis = 15000L;
        }
    }

    LoggerContext getLoggerContext(final ClassLoader classLoader) {
        LoggerContext ctx;
        try {
            int key = this.computeKey(classLoader);
            ctx = (LoggerContext)this.activeContexts.get((Object)key, (Callable)new Callable<LoggerContext>(){

                @Override
                public LoggerContext call() throws Exception {
                    return LoggerContextCache.this.artifactAwareContextSelector.buildContext(classLoader);
                }
            });
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not init logger context "), (Throwable)e);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            ctx.start();
        }
        return ctx;
    }

    void remove(ClassLoader classLoader) {
        Integer key = this.computeKey(classLoader);
        LoggerContext context = (LoggerContext)this.activeContexts.getIfPresent((Object)key);
        if (context != null) {
            this.disposeContext(key, context);
        }
    }

    void remove(LoggerContext context) {
        for (Map.Entry entry : this.activeContexts.asMap().entrySet()) {
            if (entry.getValue() != context) continue;
            this.disposeContext((Integer)entry.getKey(), context);
            return;
        }
    }

    List<LoggerContext> getAllLoggerContexts() {
        return ImmutableList.copyOf(this.activeContexts.asMap().values());
    }

    private void disposeContext(Integer key, LoggerContext loggerContext) {
        this.disposedContexts.put((Object)key, (Object)loggerContext);
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                LoggerContextCache.this.disposedContexts.cleanUp();
            }
        }, this.disposeDelayInMillis + 1L, TimeUnit.MILLISECONDS);
    }

    private int computeKey(ClassLoader classLoader) {
        return classLoader.hashCode();
    }

    public void dispose() {
        this.executorService.shutdownNow();
        for (LoggerContext loggerContext : this.activeContexts.asMap().values()) {
            this.stop(loggerContext);
        }
        this.activeContexts.invalidateAll();
        this.disposedContexts.invalidateAll();
        this.disposedContexts.cleanUp();
    }
}

