/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import java.math.BigInteger;
import jnr.ffi.LastError;
import jnr.ffi.Runtime;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.cext.GC;
import org.jruby.cext.GIL;
import org.jruby.cext.Handle;
import org.jruby.cext.Native;
import org.jruby.cext.NativeMethod;
import org.jruby.cext.NativeMethod0;
import org.jruby.cext.NativeMethod1;
import org.jruby.cext.NativeMethod2;
import org.jruby.cext.NativeMethod3;
import org.jruby.cext.NativeProcMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JRuby {
    private static final BigInteger UINT64_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

    public static long callRubyMethod(IRubyObject recv2, Object methodName, IRubyObject[] args2) {
        IRubyObject retval = recv2.callMethod(recv2.getRuntime().getCurrentContext(), methodName.toString(), args2);
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethodB(IRubyObject recv2, Object methodName, IRubyObject[] args2, IRubyObject blockProc) {
        IRubyObject retval = recv2.callMethod(recv2.getRuntime().getCurrentContext(), methodName.toString(), args2, ((RubyProc)blockProc).getBlock());
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethod0(IRubyObject recv2, Object methodName) {
        IRubyObject retval = Helpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, methodName.toString());
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethod1(IRubyObject recv2, Object methodName, IRubyObject arg1) {
        IRubyObject retval = Helpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, methodName.toString(), arg1);
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethod2(IRubyObject recv2, Object methodName, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject retval = Helpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, methodName.toString(), arg1, arg2);
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethod3(IRubyObject recv2, Object methodName, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        IRubyObject retval = Helpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, methodName.toString(), arg1, arg2, arg3);
        return Handle.nativeHandle(retval);
    }

    public static long callSuperMethod(Ruby runtime, IRubyObject[] args2) {
        ThreadContext currentContext = runtime.getCurrentContext();
        IRubyObject retval = Helpers.invokeSuper(currentContext, runtime.getCurrentContext().getFrameSelf(), args2, Block.NULL_BLOCK);
        return Handle.nativeHandle(retval);
    }

    public static long instanceEval(IRubyObject self2, IRubyObject[] args2) {
        Ruby runtime = self2.getRuntime();
        ThreadContext ctxt = runtime.getCurrentContext();
        Block block = ctxt.getFrameBlock();
        IRubyObject retval = self2.callMethod(ctxt, "instance_eval", args2, block);
        return Handle.nativeHandle(retval);
    }

    public static long newString(Ruby runtime, byte[] bytes2, int length2, boolean tainted) {
        RubyString retval = RubyString.newStringNoCopy(runtime, bytes2);
        if (tainted) {
            retval.setTaint(tainted);
        }
        retval.getByteList().setRealSize(length2);
        return Handle.nativeHandle(retval);
    }

    public static DynamicMethod newMethod(RubyModule module, long fn, int arity2) {
        switch (arity2) {
            case 0: {
                return new NativeMethod0(module, arity2, fn);
            }
            case 1: {
                return new NativeMethod1(module, arity2, fn);
            }
            case 2: {
                return new NativeMethod2(module, arity2, fn);
            }
            case 3: {
                return new NativeMethod3(module, arity2, fn);
            }
        }
        return new NativeMethod(module, arity2, fn);
    }

    public static RubyFloat newFloat(Ruby runtime, long handle, double value2) {
        RubyFloat f = RubyFloat.newFloat(runtime, value2);
        GC.register(f, Handle.newHandle(runtime, f, handle));
        return f;
    }

    public static IRubyObject newThread(Ruby runtime, long fn, IRubyObject args_ary) {
        IRubyObject[] iRubyObjectArray;
        RubyProc proc2 = (RubyProc)JRuby.newProc(runtime, fn);
        if (args_ary instanceof RubyArray) {
            iRubyObjectArray = ((RubyArray)args_ary).toJavaArray();
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args_ary;
        }
        IRubyObject[] args2 = iRubyObjectArray;
        return RubyThread.newInstance(runtime.getThread(), args2, proc2.getBlock());
    }

    public static IRubyObject newProc(Ruby runtime, long fn) {
        String name2 = System.currentTimeMillis() + "$block_jruby-cext";
        IRubyObject recv2 = runtime.getCurrentContext().getFrameSelf();
        RubyMethod method2 = RubyMethod.newMethod(recv2.getMetaClass(), name2, recv2.getMetaClass(), name2, new NativeProcMethod(recv2.getMetaClass(), fn), recv2);
        IRubyObject proc2 = method2.to_proc(runtime.getCurrentContext(), Block.NULL_BLOCK);
        return proc2;
    }

    public static IRubyObject yield(Ruby runtime, RubyArray args2) {
        return runtime.getCurrentContext().getFrameBlock().call(runtime.getCurrentContext(), args2.toJavaArray());
    }

    public static int blockGiven(Ruby runtime) {
        return runtime.getCurrentContext().getFrameBlock().isGiven() ? 1 : 0;
    }

    public static RubyProc getBlockProc(Ruby runtime) {
        Block block = runtime.getCurrentContext().getFrameBlock();
        RubyProc p2 = RubyProc.newProc(runtime, block, block.type);
        return p2;
    }

    public static long ll2inum(Ruby runtime, long l) {
        RubyFixnum n = RubyFixnum.newFixnum(runtime, l);
        Handle h = GC.lookup(n);
        if (h != null) {
            return h.getAddress();
        }
        h = Handle.newHandle(runtime, n, Native.getInstance(runtime).newFixnumHandle(n, l));
        GC.register(n, h);
        return h.getAddress();
    }

    public static long ull2inum(Ruby runtime, long l) {
        RubyInteger n = l < 0L ? RubyBignum.newBignum(runtime, BigInteger.valueOf(l & Long.MAX_VALUE).add(UINT64_BASE)) : runtime.newFixnum(l);
        Handle h = GC.lookup(n);
        if (h != null) {
            return h.getAddress();
        }
        h = Handle.newHandle(runtime, n, Native.getInstance(runtime).newFixnumHandle(n, l));
        GC.register(n, h);
        return h.getAddress();
    }

    public static long int2big(Ruby runtime, long l) {
        return Handle.nativeHandle(RubyBignum.newBignum(runtime, l));
    }

    public static long uint2big(Ruby runtime, long l) {
        RubyBignum retval = l < 0L ? RubyBignum.newBignum(runtime, BigInteger.valueOf(l & Long.MAX_VALUE).add(UINT64_BASE)) : RubyBignum.newBignum(runtime, l);
        return Handle.nativeHandle(retval);
    }

    public static long gv_set(Ruby runtime, String name2, IRubyObject value2) {
        return Handle.nativeHandle(runtime.getGlobalVariables().set(name2, value2));
    }

    public static long gv_get(Ruby runtime, String name2) {
        return Handle.nativeHandle(runtime.getGlobalVariables().get(name2));
    }

    public static void clearErrorInfo(Ruby runtime) {
        runtime.getCurrentContext().setErrorInfo(runtime.getNil());
    }

    public static void sysFail(Ruby runtime, String message2) {
        int n = LastError.getLastError((Runtime)Runtime.getSystemRuntime());
        JRuby.sysFail(runtime, message2, n);
    }

    public static void sysFail(Ruby runtime, String message2, int n) {
        IRubyObject arg2 = message2 != null ? runtime.newString(message2) : runtime.getNil();
        RubyClass instance = runtime.getErrno(n);
        if (instance == null) {
            instance = runtime.getSystemCallError();
            throw new RaiseException((RubyException)instance.newInstance(runtime.getCurrentContext(), new IRubyObject[]{arg2, runtime.newFixnum(n)}, Block.NULL_BLOCK));
        }
        throw new RaiseException((RubyException)instance.newInstance(runtime.getCurrentContext(), new IRubyObject[]{arg2}, Block.NULL_BLOCK));
    }

    public static void threadSleep(Ruby runtime, int interval) {
        try {
            runtime.getCurrentContext().getThread().sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long getMetaClass(IRubyObject object) {
        RubyClass metaClass = object.getMetaClass();
        return Handle.nativeHandle(metaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nativeBlockingRegion(Ruby runtime, long blocking_func, long blocking_data, long unblocking_func, long unblocking_data) {
        RubyThread thread2 = runtime.getCurrentContext().getThread();
        NativeFunctionTask task = new NativeFunctionTask(Native.getInstance(runtime), blocking_func, blocking_data, unblocking_func, unblocking_data);
        GC.disable();
        int lockCount = GIL.releaseAllLocks();
        try {
            thread2.executeBlockingTask(task);
        }
        catch (InterruptedException e) {
        }
        finally {
            GIL.acquire(lockCount);
            GC.enable();
        }
        return task.retval;
    }

    public static final class NativeFunctionTask
    implements RubyThread.BlockingTask {
        private Native nativeInstance;
        private long run;
        private long run_data;
        private long wakeup;
        private long wakeup_data = 0L;
        public long retval = 4L;

        public NativeFunctionTask(Native nativeInstance, long run2, long run_data, long wakeup2, long wakeup_data) {
            this.nativeInstance = nativeInstance;
            this.run = run2;
            this.run_data = run_data;
            this.wakeup = wakeup2;
            this.wakeup_data = wakeup_data;
        }

        @Override
        public void run() throws InterruptedException {
            this.retval = this.nativeInstance.callFunction(this.run, this.run_data);
        }

        @Override
        public void wakeup() {
            this.nativeInstance.callFunction(this.wakeup, this.wakeup_data);
        }
    }
}

