/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.util.ShellLauncher;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

public class OpenFile {
    public static final int READABLE = 1;
    public static final int WRITABLE = 2;
    public static final int READWRITE = 3;
    public static final int BINMODE = 4;
    public static final int SYNC = 8;
    public static final int WBUF = 16;
    public static final int RBUF = 32;
    public static final int APPEND = 64;
    public static final int CREATE = 128;
    public static final int WSPLIT = 512;
    public static final int WSPLIT_INITIALIZED = 1024;
    public static final int TRUNC = 2048;
    public static final int TEXTMODE = 4096;
    public static final int SETENC_BY_BOM = 0x100000;
    public static final int SYNCWRITE = 10;
    private Stream mainStream;
    private Stream pipeStream;
    private int mode;
    private Process process;
    private int lineNumber = 0;
    private String path;
    private Finalizer finalizer;

    public Stream getMainStream() {
        return this.mainStream;
    }

    public Stream getMainStreamSafe() throws BadDescriptorException {
        Stream stream = this.mainStream;
        if (stream == null) {
            throw new BadDescriptorException();
        }
        return stream;
    }

    public void setMainStream(Stream mainStream) {
        this.mainStream = mainStream;
    }

    public Stream getPipeStream() {
        return this.pipeStream;
    }

    public Stream getPipeStreamSafe() throws BadDescriptorException {
        Stream stream = this.pipeStream;
        if (stream == null) {
            throw new BadDescriptorException();
        }
        return stream;
    }

    public void setPipeStream(Stream pipeStream) {
        this.pipeStream = pipeStream;
    }

    public Stream getWriteStream() {
        return this.pipeStream == null ? this.mainStream : this.pipeStream;
    }

    public Stream getWriteStreamSafe() throws BadDescriptorException {
        Stream stream;
        Stream stream2 = stream = this.pipeStream == null ? this.mainStream : this.pipeStream;
        if (stream == null) {
            throw new BadDescriptorException();
        }
        return stream;
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString(Ruby runtime) {
        String modeString = OpenFile.getStringFromMode(this.mode);
        if (modeString == null) {
            throw runtime.newArgumentError("Illegal access modenum " + Integer.toOctalString(this.mode));
        }
        return modeString;
    }

    public static int getModeFlagsAsIntFrom(int oflags) {
        int flags = 0;
        if ((oflags & 1) != 0) {
            flags = (oflags & 2) != 0 ? (flags |= ModeFlags.RDWR) : (flags |= ModeFlags.RDONLY);
        } else if ((oflags & 2) != 0) {
            flags |= ModeFlags.WRONLY;
        }
        if ((oflags & 0x40) != 0) {
            flags |= ModeFlags.APPEND;
        }
        if ((oflags & 0x80) != 0) {
            flags |= ModeFlags.CREAT;
        }
        if ((oflags & 4) != 0) {
            flags |= ModeFlags.BINARY;
        }
        if ((oflags & 0x1000) != 0) {
            flags |= 0x10000000;
        }
        if ((oflags & 0x800) != 0) {
            flags |= ModeFlags.TRUNC;
        }
        return flags;
    }

    public static int getFModeFromString(String modesString) throws InvalidValueException {
        int fmode = 0;
        int length2 = modesString.length();
        if (length2 == 0) {
            throw new InvalidValueException();
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                fmode |= 1;
                break;
            }
            case 'w': {
                fmode |= 0x882;
                break;
            }
            case 'a': {
                fmode |= 0xC2;
                break;
            }
            default: {
                throw new InvalidValueException();
            }
        }
        block11: for (int n = 1; n < length2; ++n) {
            switch (modesString.charAt(n)) {
                case 'b': {
                    fmode |= 4;
                    continue block11;
                }
                case 't': {
                    fmode |= 0x1000;
                    continue block11;
                }
                case '+': {
                    fmode |= 3;
                    continue block11;
                }
                case ':': {
                    break block11;
                }
                default: {
                    throw new InvalidValueException();
                }
            }
        }
        return fmode;
    }

    public static String getStringFromMode(int mode2) {
        if ((mode2 & 0x40) != 0) {
            if ((mode2 & 3) != 0) {
                return "ab+";
            }
            return "ab";
        }
        switch (mode2 & 3) {
            case 1: {
                return "rb";
            }
            case 2: {
                return "wb";
            }
            case 3: {
                if ((mode2 & 0x80) != 0) {
                    return "wb+";
                }
                return "rb+";
            }
        }
        return null;
    }

    public void checkReadable(Ruby runtime) throws IOException, BadDescriptorException, InvalidValueException {
        this.checkClosed(runtime);
        if ((this.mode & 1) == 0) {
            throw runtime.newIOError("not opened for reading");
        }
        if (!((this.mode & 0x10) == 0 && (this.mode & 0x2A) != 10 || this.mainStream.feof() || this.pipeStream != null)) {
            try {
                this.seek(0L, 1);
            }
            catch (PipeException p2) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void seek(long offset2, int whence) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        Stream stream = this.getWriteStreamSafe();
        this.seekInternal(stream, offset2, whence);
    }

    private void seekInternal(Stream stream, long offset2, int whence) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.flushBeforeSeek(stream);
        stream.lseek(offset2, whence);
    }

    private void flushBeforeSeek(Stream stream) throws BadDescriptorException, IOException {
        if ((this.mode & 0x10) != 0) {
            this.fflush(stream);
        }
    }

    public void fflush(Stream stream) throws IOException, BadDescriptorException {
        int n;
        while ((n = stream.fflush()) == -1) {
        }
        this.mode &= 0xFFFFFFEF;
    }

    public void checkWritable(Ruby runtime) throws IOException, BadDescriptorException, InvalidValueException {
        this.checkClosed(runtime);
        if ((this.mode & 2) == 0) {
            throw runtime.newIOError("not opened for writing");
        }
        if ((this.mode & 0x20) != 0 && !this.mainStream.feof() && this.pipeStream == null) {
            try {
                this.seek(0L, 1);
            }
            catch (PipeException p2) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.pipeStream == null) {
            this.mode &= 0xFFFFFFDF;
        }
    }

    public void checkClosed(Ruby runtime) {
        if (this.mainStream == null && this.pipeStream == null) {
            throw runtime.newIOError("closed stream");
        }
    }

    public boolean isBinmode() {
        return (this.mode & 4) != 0;
    }

    public boolean isTextMode() {
        return (this.mode & 0x1000) != 0;
    }

    public void setTextMode() {
        this.mode |= 0x1000;
    }

    public void clearTextMode() {
        this.mode &= 0xFFFFEFFF;
    }

    public void setBinmode() {
        this.mode |= 4;
        if (this.mainStream != null) {
            this.mainStream.setBinmode();
        }
        if (this.pipeStream != null) {
            this.pipeStream.setBinmode();
        }
    }

    public boolean isOpen() {
        return this.mainStream != null || this.pipeStream != null;
    }

    public boolean isReadable() {
        return (this.mode & 1) != 0;
    }

    public boolean isWritable() {
        return (this.mode & 2) != 0;
    }

    public boolean isReadBuffered() {
        return (this.mode & 0x20) != 0;
    }

    public void setReadBuffered() {
        this.mode |= 0x20;
    }

    public boolean isWriteBuffered() {
        return (this.mode & 0x10) != 0;
    }

    public void setWriteBuffered() {
        this.mode |= 0x10;
    }

    public void setSync(boolean sync2) {
        this.mode = sync2 ? (this.mode |= 8) : (this.mode &= 0xFFFFFFF7);
    }

    public boolean isSync() {
        return (this.mode & 8) != 0;
    }

    public boolean areBothEOF() throws IOException, BadDescriptorException {
        return this.mainStream.feof() && (this.pipeStream == null || this.pipeStream.feof());
    }

    public void setMode(int modes) {
        this.mode = modes;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public long getPid() {
        return ShellLauncher.getPidFromProcess(this.process);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path2) {
        this.path = path2;
    }

    public boolean isAutoclose() {
        Stream myPipe;
        boolean autoclose2 = true;
        Stream myMain = this.mainStream;
        if (myMain != null) {
            autoclose2 &= myMain.isAutoclose();
        }
        if ((myPipe = this.pipeStream) != null) {
            autoclose2 &= myPipe.isAutoclose();
        }
        return autoclose2;
    }

    public void setAutoclose(boolean autoclose2) {
        Stream myPipe;
        Stream myMain = this.mainStream;
        if (myMain != null) {
            myMain.setAutoclose(autoclose2);
        }
        if ((myPipe = this.pipeStream) != null) {
            myPipe.setAutoclose(autoclose2);
        }
    }

    public Finalizer getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(Finalizer finalizer) {
        this.finalizer = finalizer;
    }

    public void cleanup(Ruby runtime, boolean raise2) {
        if (this.finalizer != null) {
            this.finalizer.finalize(runtime, raise2);
        } else {
            this.finalize(runtime, raise2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize(Ruby runtime, boolean raise2) {
        try {
            ChannelDescriptor pipe2 = null;
            boolean isProcess = this.process != null;
            OpenFile openFile = this;
            synchronized (openFile) {
                block31: {
                    Stream ms;
                    Stream ps = this.pipeStream;
                    if (ps != null) {
                        pipe2 = ps.getDescriptor();
                        try {
                            if (isProcess && ps.getChannel().isOpen() || !isProcess) {
                                ps.fflush();
                                ps.fclose();
                            }
                        }
                        finally {
                            this.pipeStream = null;
                        }
                    }
                    if ((ms = this.mainStream) != null) {
                        ChannelDescriptor main2 = ms.getDescriptor();
                        runtime.removeFilenoIntMap(main2.getFileno());
                        try {
                            if (isProcess) {
                                if (!ms.getChannel().isOpen()) break block31;
                                if (pipe2 == null && this.isWriteBuffered()) {
                                    ms.fflush();
                                }
                                try {
                                    ms.fclose();
                                    break block31;
                                }
                                catch (IOException ioe) {
                                    if (!ioe.getMessage().equals("Bad file descriptor")) {
                                        throw ioe;
                                    }
                                    boolean isAlive = false;
                                    try {
                                        this.process.exitValue();
                                    }
                                    catch (IllegalThreadStateException itse) {
                                        isAlive = true;
                                    }
                                    if (isAlive) {
                                        throw ioe;
                                    }
                                    break block31;
                                }
                            }
                            if (pipe2 == null && this.isWriteBuffered()) {
                                ms.fflush();
                            }
                            ms.fclose();
                        }
                        catch (BadDescriptorException bde) {
                            if (main2 != pipe2) {
                                throw bde;
                            }
                        }
                        finally {
                            this.mainStream = null;
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            if (raise2) {
                throw runtime.newIOErrorFromException(ex);
            }
        }
        catch (BadDescriptorException ex) {
            if (raise2) {
                throw runtime.newErrnoEBADFError();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static interface Finalizer {
        public void finalize(Ruby var1, boolean var2);
    }
}

