/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.Predicate;
import org.mule.extension.exception.NoSuchExtensionException;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.module.extension.internal.manager.ExtensionStateTracker;
import org.mule.util.CollectionUtils;

final class ExtensionRegister {
    private final LoadingCache<Extension, ExtensionStateTracker> extensionStates = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Extension, ExtensionStateTracker>(){

        public ExtensionStateTracker load(Extension key) throws Exception {
            return new ExtensionStateTracker();
        }
    });
    private final Map<String, Extension> extensions = new ConcurrentHashMap<String, Extension>();
    private final Map<Configuration, Extension> configuration2ExtensionCache = new ConcurrentHashMap<Configuration, Extension>();
    private final Map<Operation, Extension> operation2ExtensionCache = new ConcurrentHashMap<Operation, Extension>();
    private final Map<Class<?>, Set<Extension>> capability2ExtensionCache = new ConcurrentHashMap();

    ExtensionRegister() {
    }

    void registerExtension(String name, Extension extension) {
        this.extensions.put(name, extension);
        this.clearCaches();
    }

    Set<Extension> getExtensions() {
        return ImmutableSet.copyOf(this.extensions.values());
    }

    boolean containsExtension(String name) {
        return this.extensions.containsKey(name);
    }

    Extension getExtension(String name) {
        return this.extensions.get(name);
    }

    Extension getExtension(final Configuration configuration) {
        Extension extension = this.lookupInCache(this.configuration2ExtensionCache, configuration, new Predicate(){

            public boolean evaluate(Object object) {
                Extension extension = (Extension)object;
                return extension.getConfiguration(configuration.getName()) == configuration;
            }
        });
        if (extension == null) {
            throw new NoSuchExtensionException("Could not find a registered extension which contains the configuration " + configuration.getName());
        }
        return extension;
    }

    Extension getExtension(final Operation operation) {
        Extension extension = this.lookupInCache(this.operation2ExtensionCache, operation, new Predicate(){

            public boolean evaluate(Object object) {
                Extension extension = (Extension)object;
                return extension.getOperation(operation.getName()) == operation;
            }
        });
        if (extension == null) {
            throw new NoSuchExtensionException("Could not find a registered extension which contains the operation " + operation.getName());
        }
        return extension;
    }

    ExtensionStateTracker getExtensionState(Extension extension) {
        return (ExtensionStateTracker)this.extensionStates.getUnchecked((Object)extension);
    }

    ExtensionStateTracker getExtensionState(Configuration configuration) {
        return this.getExtensionState(this.getExtension(configuration));
    }

    Map<String, ConfigurationInstanceProvider> getConfigurationInstanceProviders() {
        ImmutableMap.Builder providers = ImmutableMap.builder();
        for (Extension extension : this.extensions.values()) {
            providers.putAll(this.getConfigurationInstanceProviders(extension));
        }
        return providers.build();
    }

    Map<String, ConfigurationInstanceProvider> getConfigurationInstanceProviders(Extension extension) {
        ImmutableMap.Builder providers = ImmutableMap.builder();
        for (Configuration configuration : extension.getConfigurations()) {
            providers.putAll(this.getExtensionState(configuration).getConfigurationInstanceProviders(configuration));
        }
        return providers.build();
    }

    ExtensionStateTracker getExtensionState(Operation operation) {
        return this.getExtensionState(this.getExtension(operation));
    }

    <C> Set<Extension> getExtensionsCapableOf(Class<C> capabilityType) {
        ImmutableSet cachedCapables = this.capability2ExtensionCache.get(capabilityType);
        if (CollectionUtils.isEmpty(cachedCapables)) {
            ImmutableSet.Builder capables = ImmutableSet.builder();
            for (Extension extension : this.getExtensions()) {
                if (!extension.isCapableOf(capabilityType)) continue;
                capables.add((Object)extension);
            }
            cachedCapables = capables.build();
            this.capability2ExtensionCache.put(capabilityType, (Set<Extension>)cachedCapables);
        }
        return cachedCapables;
    }

    private void clearCaches() {
        this.configuration2ExtensionCache.clear();
        this.operation2ExtensionCache.clear();
        this.capability2ExtensionCache.clear();
    }

    private <K, V> V lookupInCache(Map<K, V> cache, K key, Predicate predicate) {
        Object value = cache.get(key);
        if (value == null && (value = CollectionUtils.find(this.extensions.values(), (Predicate)predicate)) != null) {
            cache.put(key, value);
        }
        return value;
    }
}

