/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.AttributeEvaluator;
import org.mule.util.Preconditions;

public class EvaluateAndTransformValueResolver<T>
implements ValueResolver<T> {
    private final org.mule.extension.introspection.DataType expectedType;
    private final AttributeEvaluator evaluator;
    private MuleContext muleContext;
    private EvaluatorDelegate delegate = new CaptureContextEvaluatorDelegate();

    public EvaluateAndTransformValueResolver(String expression, org.mule.extension.introspection.DataType expectedType) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        Preconditions.checkArgument((expectedType != null ? 1 : 0) != 0, (String)"expected type cannot be null");
        this.expectedType = expectedType;
        this.evaluator = new AttributeEvaluator(expression);
    }

    @Override
    public T resolve(MuleEvent event) throws MuleException {
        Object evaluated = this.delegate.resolveValue(event);
        return (T)(evaluated != null ? this.transform(evaluated, event) : null);
    }

    private T transform(T object, MuleEvent event) throws MuleException {
        Transformer transformer;
        if (this.expectedType.getRawType().isInstance(object)) {
            return object;
        }
        Type expectedClass = this.expectedType.getRawType();
        if (expectedClass instanceof ParameterizedType) {
            expectedClass = ((ParameterizedType)expectedClass).getRawType();
        }
        DataType sourceDataType = DataTypeFactory.create(object.getClass());
        DataType targetDataType = DataTypeFactory.create((Class)expectedClass);
        try {
            transformer = this.muleContext.getRegistry().lookupTransformer(sourceDataType, targetDataType);
        }
        catch (TransformerException e) {
            return object;
        }
        if (transformer != null) {
            if (transformer instanceof MessageTransformer) {
                return (T)((MessageTransformer)transformer).transform(object, event);
            }
            return (T)transformer.transform(object);
        }
        return object;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    private class PassThroughEvaluatorDelegate
    implements EvaluatorDelegate {
        private PassThroughEvaluatorDelegate() {
        }

        @Override
        public synchronized Object resolveValue(MuleEvent event) {
            return EvaluateAndTransformValueResolver.this.evaluator.resolveValue(event);
        }
    }

    private class CaptureContextEvaluatorDelegate
    implements EvaluatorDelegate {
        private CaptureContextEvaluatorDelegate() {
        }

        @Override
        public synchronized Object resolveValue(MuleEvent event) {
            if (EvaluateAndTransformValueResolver.this.muleContext == null) {
                EvaluateAndTransformValueResolver.this.muleContext = event.getMuleContext();
                EvaluateAndTransformValueResolver.this.evaluator.initialize(EvaluateAndTransformValueResolver.this.muleContext.getExpressionManager());
                EvaluateAndTransformValueResolver.this.delegate = new PassThroughEvaluatorDelegate();
            }
            return EvaluateAndTransformValueResolver.this.delegate.resolveValue(event);
        }
    }

    private static interface EvaluatorDelegate {
        public Object resolveValue(MuleEvent var1);
    }
}

