/*
 * Decompiled with CFR 0.152.
 */
package org.mule.enricher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.processor.InternalMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.api.processor.MessageProcessors;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.processor.AbstractRequestResponseMessageProcessor;
import org.mule.processor.chain.InterceptingChainLifecycleWrapper;
import org.mule.transformer.types.TypedValue;
import org.mule.util.StringUtils;

public class MessageEnricher
extends AbstractMessageProcessorOwner
implements MessageProcessor,
NonBlockingSupported {
    private List<EnrichExpressionPair> enrichExpressionPairs = new ArrayList<EnrichExpressionPair>();
    private MessageProcessor enrichmentProcessor;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        return new EnricherProcessor(this.enrichmentProcessor, this.muleContext).process(event);
    }

    protected void enrich(MuleMessage currentMessage, MuleMessage enrichmentMessage, String sourceExpressionArg, String targetExpressionArg, ExpressionManager expressionManager) {
        TypedValue typedValue;
        if (StringUtils.isEmpty((String)sourceExpressionArg)) {
            sourceExpressionArg = "#[payload:]";
        }
        if ((typedValue = expressionManager.evaluateTyped(sourceExpressionArg, enrichmentMessage)).getValue() instanceof MuleMessage) {
            MuleMessage muleMessage = (MuleMessage)typedValue.getValue();
            typedValue = new TypedValue(muleMessage.getPayload(), muleMessage.getDataType());
        }
        if (!StringUtils.isEmpty((String)targetExpressionArg)) {
            expressionManager.enrichTyped(targetExpressionArg, currentMessage, typedValue);
        } else {
            currentMessage.setPayload(typedValue.getValue(), typedValue.getDataType());
        }
    }

    public void setEnrichmentMessageProcessor(MessageProcessor enrichmentProcessor) {
        this.enrichmentProcessor = !(enrichmentProcessor instanceof MessageProcessorChain) ? MessageProcessors.singletonChain(enrichmentProcessor) : enrichmentProcessor;
    }

    public void setMessageProcessor(MessageProcessor enrichmentProcessor) {
        this.setEnrichmentMessageProcessor(enrichmentProcessor);
    }

    public void setEnrichExpressionPairs(List<EnrichExpressionPair> enrichExpressionPairs) {
        this.enrichExpressionPairs = enrichExpressionPairs;
    }

    public void addEnrichExpressionPair(EnrichExpressionPair pair) {
        this.enrichExpressionPairs.add(pair);
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.enrichmentProcessor);
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        if (this.enrichmentProcessor instanceof InterceptingChainLifecycleWrapper) {
            super.addMessageProcessorPathElements(pathElement);
        } else {
            ((MessageProcessorContainer)((Object)this.enrichmentProcessor)).addMessageProcessorPathElements(pathElement);
        }
    }

    private class EnricherProcessor
    extends AbstractRequestResponseMessageProcessor
    implements InternalMessageProcessor {
        private MuleEvent eventToEnrich;

        protected EnricherProcessor(MessageProcessor enrichmentProcessor, MuleContext muleContext) {
            this.next = enrichmentProcessor;
            this.muleContext = muleContext;
        }

        @Override
        protected MuleEvent processRequest(MuleEvent event) throws MuleException {
            this.eventToEnrich = event;
            return OptimizedRequestContext.unsafeSetEvent(DefaultMuleEvent.copy(event));
        }

        @Override
        protected MuleEvent processResponse(MuleEvent event) throws MuleException {
            ExpressionManager expressionManager = this.eventToEnrich.getMuleContext().getExpressionManager();
            if (event != null && !VoidMuleEvent.getInstance().equals(this.eventToEnrich)) {
                for (EnrichExpressionPair pair : MessageEnricher.this.enrichExpressionPairs) {
                    MessageEnricher.this.enrich(this.eventToEnrich.getMessage(), event.getMessage(), pair.getSource(), pair.getTarget(), expressionManager);
                }
            }
            if (this.muleContext != null && this.muleContext.getConfiguration().isEnricherPropagatesSessionVariableChanges()) {
                this.eventToEnrich = new DefaultMuleEvent(this.eventToEnrich.getMessage(), this.eventToEnrich, event.getSession());
            }
            return OptimizedRequestContext.unsafeSetEvent(this.eventToEnrich);
        }
    }

    public static class EnrichExpressionPair {
        private String source;
        private String target;

        public EnrichExpressionPair() {
        }

        public EnrichExpressionPair(String target) {
            this.target = target;
        }

        public EnrichExpressionPair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }
}

