/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.management.stats.Statistics;
import org.mule.management.stats.ProcessingTime;
import org.mule.management.stats.printers.SimplePrinter;
import org.mule.util.StringUtils;

public class ComponentStatistics
implements Statistics {
    private static final Log logger = LogFactory.getLog(ComponentStatistics.class);
    private static final long serialVersionUID = -2086999226732861674L;
    private long minExecutionTime = 0L;
    private long maxExecutionTime = 0L;
    private long averageExecutionTime = 0L;
    private long executedEvent = 0L;
    private long totalExecTime = 0L;
    private boolean enabled = false;
    private long intervalTime = 0L;
    private long currentIntervalStartTime = 0L;
    private boolean statIntervalTimeEnabled = false;

    public ComponentStatistics() {
        String intervalTimeString = System.getProperty("statIntervalTime");
        if (StringUtils.isBlank((String)intervalTimeString)) {
            this.statIntervalTimeEnabled = false;
        } else {
            try {
                this.intervalTime = Integer.parseInt(intervalTimeString);
                this.statIntervalTimeEnabled = true;
            }
            catch (NumberFormatException e) {
                this.statIntervalTimeEnabled = false;
                logger.warn((Object)("Couldn't parse statIntervalTime: " + intervalTimeString + ". Disabled."));
            }
        }
    }

    public void clear() {
        this.minExecutionTime = 0L;
        this.maxExecutionTime = 0L;
        this.executedEvent = 0L;
        this.totalExecTime = 0L;
        this.averageExecutionTime = 0L;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void logSummary() {
        this.logSummary(new SimplePrinter(System.out));
    }

    public void logSummary(PrintWriter printer) {
        printer.print(this);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public long getMinExecutionTime() {
        return this.minExecutionTime;
    }

    public long getTotalExecutionTime() {
        return this.totalExecTime;
    }

    public long getExecutedEvents() {
        return this.executedEvent;
    }

    public synchronized void addExecutionBranchTime(boolean first, long branch, long total) {
        if (this.statIntervalTimeEnabled) {
            long currentTime = System.currentTimeMillis();
            if (this.currentIntervalStartTime == 0L) {
                this.currentIntervalStartTime = currentTime;
            }
            if (currentTime - this.currentIntervalStartTime > this.intervalTime) {
                this.clear();
                this.currentIntervalStartTime = currentTime;
            }
        }
        if (first) {
            ++this.executedEvent;
        }
        this.totalExecTime += ProcessingTime.getEffectiveTime(branch);
        long effectiveTotal = ProcessingTime.getEffectiveTime(total);
        if (this.maxExecutionTime == 0L || effectiveTotal > this.maxExecutionTime) {
            this.maxExecutionTime = effectiveTotal;
        }
        this.averageExecutionTime = Math.round(this.totalExecTime / this.executedEvent);
    }

    public synchronized void addCompleteExecutionTime(long time) {
        long effectiveTime = ProcessingTime.getEffectiveTime(time);
        if (this.minExecutionTime == 0L || effectiveTime < this.minExecutionTime) {
            this.minExecutionTime = effectiveTime;
        }
    }

    public synchronized void addExecutionTime(long time) {
        if (this.statIntervalTimeEnabled) {
            long currentTime = System.currentTimeMillis();
            if (this.currentIntervalStartTime == 0L) {
                this.currentIntervalStartTime = currentTime;
            }
            if (currentTime - this.currentIntervalStartTime > this.intervalTime) {
                this.clear();
                this.currentIntervalStartTime = currentTime;
            }
        }
        ++this.executedEvent;
        long effectiveTime = ProcessingTime.getEffectiveTime(time);
        this.totalExecTime += effectiveTime;
        if (this.minExecutionTime == 0L || effectiveTime < this.minExecutionTime) {
            this.minExecutionTime = time;
        }
        if (this.maxExecutionTime == 0L || effectiveTime > this.maxExecutionTime) {
            this.maxExecutionTime = time;
        }
        this.averageExecutionTime = Math.round(this.totalExecTime / this.executedEvent);
    }

    public long getAverageExecutionTime() {
        return this.averageExecutionTime;
    }
}

