/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.db.internal.result.statement;

import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

/**
 * Processes {@link Statement} results and then closes the statement.
 */
public class EagerStatementResultHandler extends AbstractMapStatementResultHandler
{

    public EagerStatementResultHandler(ResultSetHandler resultSetHandler)
    {
        super(resultSetHandler);
    }

    @Override
    public Object processStatement(DbConnection connection, Statement statement, QueryTemplate queryTemplate, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) throws SQLException
    {
        try
        {
            return super.processStatement(connection, statement, queryTemplate, autoGeneratedKeyStrategy);
        }
        finally
        {
            try
            {
                statement.close();
            }
            finally
            {
                connection.release();
            }
        }
    }

    @Override
    protected Map<String, Object> createResultMap()
    {
        return new HashMap<String, Object>();
    }
}
