/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

public class ChannelId {
    public static final String WILD = "*";
    public static final String WILDWILD = "**";
    private static final String[] ROOT = new String[0];
    String _name;
    String[] _segments;
    int _wild;

    public ChannelId(String name) {
        this._name = name;
        if (name == null || name.length() == 0 || name.charAt(0) != '/') {
            throw new IllegalArgumentException(name);
        }
        if ("/".equals(name)) {
            this._segments = ROOT;
        } else {
            if (name.charAt(name.length() - 1) == '/') {
                throw new IllegalArgumentException(name);
            }
            this._segments = name.substring(1).split("/");
        }
        if (this._segments.length == 0) {
            this._wild = 0;
        } else if (WILD.equals(this._segments[this._segments.length - 1])) {
            this._wild = 1;
        } else if (WILDWILD.equals(this._segments[this._segments.length - 1])) {
            this._wild = 2;
        }
    }

    public boolean isWild() {
        return this._wild > 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChannelId) {
            ChannelId other = (ChannelId)obj;
            if (this.isWild()) {
                if (other.isWild()) {
                    return this._name.equals(other._name);
                }
                return this.matches(other);
            }
            if (other.isWild()) {
                return other.matches(this);
            }
            return this._name.equals(other._name);
        }
        if (obj instanceof String) {
            if (this.isWild()) {
                return this.matches((String)obj);
            }
            return this._name.equals(obj);
        }
        return false;
    }

    public boolean matches(ChannelId name) {
        if (name.isWild()) {
            return this.equals(name);
        }
        switch (this._wild) {
            case 0: {
                return this.equals(name);
            }
            case 1: {
                if (name._segments.length != this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(name._segments[i])) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                if (name._segments.length < this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(name._segments[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean matches(String name) {
        if (this._wild == 0) {
            return this._name.equals(name);
        }
        return this.matches(new ChannelId(name));
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }

    public int depth() {
        return this._segments.length;
    }

    public boolean isParentOf(ChannelId id) {
        if (this.isWild() || this.depth() >= id.depth()) {
            return false;
        }
        for (int i = this._segments.length - 1; i >= 0; --i) {
            if (this._segments[i].equals(id._segments[i])) continue;
            return false;
        }
        return true;
    }

    public String getSegment(int i) {
        if (i > this._segments.length) {
            return null;
        }
        return this._segments[i];
    }
}

