/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.extension.introspection.Capable;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.runtime.BaseObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.util.GroupValueSetter;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.module.extension.internal.util.SingleValueSetter;
import org.mule.module.extension.internal.util.ValueSetter;

public final class ConfigurationObjectBuilder
extends BaseObjectBuilder<Object> {
    private final Configuration configuration;
    private final ResolverSet resolverSet;
    private final List<ValueSetter> groupValueSetters;
    private final List<ValueSetter> singleValueSetters;

    public ConfigurationObjectBuilder(Configuration configuration, ResolverSet resolverSet) {
        this.configuration = configuration;
        this.resolverSet = resolverSet;
        this.singleValueSetters = this.createSingleValueSetters(configuration, resolverSet);
        this.groupValueSetters = GroupValueSetter.settersFor((Capable)configuration);
    }

    private List<ValueSetter> createSingleValueSetters(Configuration configuration, ResolverSet resolverSet) {
        ImmutableList.Builder singleValueSetters = ImmutableList.builder();
        Class prototypeClass = configuration.getInstantiator().getObjectType();
        for (Parameter parameter : resolverSet.getResolvers().keySet()) {
            Field field = IntrospectionUtils.getField(prototypeClass, parameter);
            if (field == null) continue;
            singleValueSetters.add((Object)new SingleValueSetter(parameter, field));
        }
        return singleValueSetters.build();
    }

    @Override
    public Object build(MuleEvent event) throws MuleException {
        return this.build(this.resolverSet.resolve(event));
    }

    public Object build(ResolverSetResult result) throws MuleException {
        Object target = this.instantiateObject();
        this.setValues(target, result, this.groupValueSetters);
        this.setValues(target, result, this.singleValueSetters);
        return target;
    }

    private void setValues(Object target, ResolverSetResult result, List<ValueSetter> setters) throws MuleException {
        for (ValueSetter setter : setters) {
            setter.set(target, result);
        }
    }

    @Override
    protected Object instantiateObject() {
        return this.configuration.getInstantiator().newInstance();
    }
}

