/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.runtime.OperationContextAdapter;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;

public class DefaultOperationContext
implements OperationContextAdapter {
    private final Operation operation;
    private final Map<Parameter, Object> parameters;
    private final Map<String, Object> parametersByName;
    private final MuleEvent event;

    public DefaultOperationContext(Operation operation, ResolverSetResult parameters, MuleEvent event) {
        this.operation = operation;
        this.event = event;
        this.parameters = parameters.asMap();
        this.parametersByName = new HashMap<String, Object>(this.parameters.size());
        for (Map.Entry<Parameter, Object> parameter : this.parameters.entrySet()) {
            this.parametersByName.put(parameter.getKey().getName(), parameter.getValue());
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Map<Parameter, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameterValue(Parameter parameter) {
        return this.parameters.get(parameter);
    }

    public Object getParameterValue(String parameterName) {
        return this.parametersByName.get(parameterName);
    }

    @Override
    public MuleEvent getEvent() {
        return this.event;
    }
}

