/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import com.google.common.base.Predicate;
import java.lang.reflect.Constructor;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.extension.internal.manager.ConfigurationInstanceWrapper;
import org.reflections.ReflectionUtils;

public final class ReflectiveDelegateFactory {
    private ConcurrentMap<DelegateKey, Object> delegates = new ConcurrentHashMap<DelegateKey, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C, D> D getDelegate(Class<D> delegateType, C configurationInstance) {
        DelegateKey key = new DelegateKey(delegateType, configurationInstance);
        C c = configurationInstance;
        synchronized (c) {
            Object delegate = this.delegates.get(key);
            if (delegate == null) {
                delegate = this.createDelegate(delegateType, configurationInstance);
                this.delegates.put(key, delegate);
            }
            return (D)delegate;
        }
    }

    private <C, D> D createDelegate(Class<D> delegateType, C configurationInstance) {
        Object delegate;
        Set suitableConstructors = ReflectionUtils.getConstructors(delegateType, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withParametersCount((int)1), ReflectionUtils.withParametersAssignableTo((Class[])new Class[]{configurationInstance.getClass()})});
        if (suitableConstructors.isEmpty()) {
            throw new IllegalArgumentException(String.format("Class %s was expected to have one public constructor with one argument of type %s but it was not found. Add such constructor in orderto execute those operations with a configuration of that type", delegateType.getName(), configurationInstance.getClass().getName()));
        }
        try {
            delegate = ((Constructor)suitableConstructors.iterator().next()).newInstance(configurationInstance);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("Could not create instance of class %s using configuration of type %s", delegateType.getName(), configurationInstance.getClass().getName())), (Throwable)e);
        }
        return (D)delegate;
    }

    private class DelegateKey {
        private final Class<?> delegateType;
        private final ConfigurationInstanceWrapper<Object> configurationInstance;
        private final int hashCode;

        private DelegateKey(Class<?> delegateType, Object configurationInstance) {
            this.delegateType = delegateType;
            this.configurationInstance = new ConfigurationInstanceWrapper<Object>(delegateType.getName(), configurationInstance);
            this.hashCode = 31 * delegateType.hashCode() * configurationInstance.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DelegateKey) {
                DelegateKey otherKey = (DelegateKey)obj;
                return this.delegateType == otherKey.delegateType && this.configurationInstance.equals(otherKey.configurationInstance);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

