/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.ConfigurationInstanceRegistrationCallback;
import org.mule.extension.runtime.OperationContext;

public final class StaticConfigurationInstanceProvider<T>
implements ConfigurationInstanceProvider<T> {
    private final String name;
    private final Configuration configuration;
    private final T configurationInstance;
    private ProviderDelegate<T> providerDelegate;

    public StaticConfigurationInstanceProvider(String name, Configuration configuration, T configurationInstance) {
        this.name = name;
        this.configuration = configuration;
        this.configurationInstance = configurationInstance;
        this.providerDelegate = new FirstTimeProviderDelegate();
    }

    public T get(OperationContext operationContext, ConfigurationInstanceRegistrationCallback registrationCallback) {
        try {
            return this.providerDelegate.provide(operationContext, registrationCallback);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    private class FixedProviderDelegate<T>
    implements ProviderDelegate<T> {
        private T configurationInstance;

        private FixedProviderDelegate(T configurationInstance) {
            this.configurationInstance = configurationInstance;
        }

        @Override
        public T provide(OperationContext operationContext, ConfigurationInstanceRegistrationCallback registrationCallback) throws MuleException {
            return this.configurationInstance;
        }
    }

    private class FirstTimeProviderDelegate<T>
    implements ProviderDelegate<T> {
        private FirstTimeProviderDelegate() {
        }

        @Override
        public synchronized T provide(OperationContext operationContext, ConfigurationInstanceRegistrationCallback registrationCallback) throws MuleException {
            if (StaticConfigurationInstanceProvider.this.providerDelegate == this) {
                registrationCallback.registerNewConfigurationInstance((ConfigurationInstanceProvider)StaticConfigurationInstanceProvider.this, StaticConfigurationInstanceProvider.this.configurationInstance);
                StaticConfigurationInstanceProvider.this.providerDelegate = new FixedProviderDelegate(StaticConfigurationInstanceProvider.this.configurationInstance);
            }
            return (T)StaticConfigurationInstanceProvider.this.configurationInstance;
        }
    }

    private static interface ProviderDelegate<T> {
        public T provide(OperationContext var1, ConfigurationInstanceRegistrationCallback var2) throws MuleException;
    }
}

