/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Described;
import org.mule.extension.introspection.Operation;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.DynamicConfigurationInstanceProvider;
import org.mule.module.extension.internal.runtime.OperationContextAdapter;
import org.mule.module.extension.internal.runtime.StaticConfigurationInstanceProvider;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.util.Preconditions;
import org.mule.util.TemplateParser;

public final class MuleExtensionUtils {
    public static void checkNullOrRepeatedNames(Collection<? extends Described> describedCollection, String describedEntityName) {
        Set<String> repeatedNames = MuleExtensionUtils.collectRepeatedNames(describedCollection, describedEntityName);
        if (!repeatedNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("The following %s were declared multiple times: [%s]", describedEntityName, Joiner.on((String)", ").join(repeatedNames)));
        }
    }

    public static void checkNamesClashes(Collection<Configuration> configurations, Collection<Operation> operations) {
        ArrayList<Object> all = new ArrayList<Object>(configurations.size() + operations.size());
        all.addAll(configurations);
        all.addAll(operations);
        Set<String> clashes = MuleExtensionUtils.collectRepeatedNames(all, "operations");
        if (!clashes.isEmpty()) {
            throw new IllegalArgumentException(String.format("The following operations have the same name as a declared configuration: [%s]", Joiner.on((String)", ").join(clashes)));
        }
    }

    private static Set<String> collectRepeatedNames(Collection<? extends Described> describedCollection, String describedEntityName) {
        String name;
        if (CollectionUtils.isEmpty(describedCollection)) {
            return ImmutableSet.of();
        }
        LinkedHashMultiset names = LinkedHashMultiset.create();
        for (Described described : describedCollection) {
            Preconditions.checkArgument((described != null ? 1 : 0) != 0, (String)String.format("A null %s was provided", describedEntityName));
            names.add((Object)described.getName());
        }
        names = Multisets.copyHighestCountFirst((Multiset)names);
        HashSet<String> repeatedNames = new HashSet<String>();
        Iterator iterator = names.iterator();
        while (iterator.hasNext() && names.count((Object)(name = (String)iterator.next())) != 1) {
            repeatedNames.add(name);
        }
        return repeatedNames;
    }

    public static <T> List<T> immutableList(Collection<T> collection) {
        return collection != null ? ImmutableList.copyOf(collection) : ImmutableList.of();
    }

    public static <T extends Described> Map<String, T> toMap(List<T> objects) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Described object : objects) {
            map.put((Object)object.getName(), (Object)object);
        }
        return map.build();
    }

    public static <T> boolean hasAnyDynamic(Iterable<ValueResolver<T>> resolvers) {
        for (ValueResolver<T> resolver : resolvers) {
            if (!resolver.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimpleExpression(String expression, TemplateParser parser) {
        TemplateParser.PatternInfo style = parser.getStyle();
        return expression.startsWith(style.getPrefix()) && expression.endsWith(style.getSuffix());
    }

    public static boolean containsExpression(String expression, TemplateParser parser) {
        return parser.isContainsTemplate(expression);
    }

    public static boolean isExpression(Object value, TemplateParser parser) {
        if (value instanceof String) {
            String maybeExpression = (String)value;
            return MuleExtensionUtils.isSimpleExpression(maybeExpression, parser) || MuleExtensionUtils.containsExpression(maybeExpression, parser);
        }
        return false;
    }

    public static <T extends Described> List<T> alphaSortDescribedList(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        Collections.sort(list, new DescribedComparator());
        return list;
    }

    public static <T> ConfigurationInstanceProvider<T> createConfigurationInstanceProvider(String name, Configuration configuration, ResolverSet resolverSet, MuleContext muleContext) throws Exception {
        ConfigurationObjectBuilder configurationObjectBuilder = new ConfigurationObjectBuilder(configuration, resolverSet);
        if (resolverSet.isDynamic()) {
            return new DynamicConfigurationInstanceProvider(name, configuration, configurationObjectBuilder, resolverSet);
        }
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(null, muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)null);
        return new StaticConfigurationInstanceProvider<Object>(name, configuration, configurationObjectBuilder.build((MuleEvent)event));
    }

    public static OperationContextAdapter asOperationContextAdapter(OperationContext operationContext) {
        Preconditions.checkArgument((operationContext != null ? 1 : 0) != 0, (String)"operationContext cannot be null");
        if (!(operationContext instanceof OperationContextAdapter)) {
            throw new IllegalArgumentException(String.format("operationContext was expected to be an instance of %s but got %s instead", OperationContextAdapter.class.getName(), operationContext.getClass().getName()));
        }
        return (OperationContextAdapter)operationContext;
    }

    public static String getDefaultValue(Optional optional) {
        if (optional == null) {
            return null;
        }
        String defaultValue = optional.defaultValue();
        return "THIS IS A SPECIAL NULL VALUE - DO NOT USE".equals(defaultValue) ? null : defaultValue;
    }

    private static class DescribedComparator
    implements Comparator<Described> {
        private DescribedComparator() {
        }

        @Override
        public int compare(Described o1, Described o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

