/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHelper {
    private static final Logger logger = LoggerFactory.getLogger(NotificationHelper.class);
    private ServerNotificationHandler serverNotificationHandler;
    private Class<? extends ServerNotification> notificationClass;

    public NotificationHelper(ServerNotificationHandler serverNotificationHandler, Class<? extends ServerNotification> notificationClass, boolean dynamicNotifications) {
        this.notificationClass = notificationClass;
        this.serverNotificationHandler = dynamicNotifications ? serverNotificationHandler : new OptimisedNotificationHandler(serverNotificationHandler, notificationClass);
    }

    public boolean isNotificationEnabled() {
        return this.serverNotificationHandler.isNotificationEnabled(this.notificationClass);
    }

    public void fireNotification(MuleMessage message, String uri, FlowConstruct flowConstruct, int action) {
        try {
            if (this.isNotificationEnabled()) {
                this.serverNotificationHandler.fireNotification(new ConnectorMessageNotification(message, uri, flowConstruct, action));
            }
        }
        catch (Exception e) {
            logger.warn("Could not fire notification. Action: " + action, (Throwable)e);
        }
    }

    public void fireNotification(ServerNotification notification) {
        this.serverNotificationHandler.fireNotification(notification);
    }
}

