/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.util.ClassUtils;

public class URIBuilder
extends AbstractAnnotatedObject {
    private static final String DOTS = ":";
    private static final String DOTS_SLASHES = "://";
    private static final String SLASH = "/";
    private static final String QUERY = "?";
    private static final String AND = "&";
    private static final String EQUALS = "=";
    private static final String BACKSLASH = "\\";
    public static final String META = "meta";
    public static final String PROTOCOL = "protocol";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String HOST = "host";
    public static final String ADDRESS = "address";
    public static final String PORT = "port";
    public static final String PATH = "path";
    public static final String[] ALL_ATTRIBUTES = new String[]{"meta", "protocol", "user", "password", "host", "address", "port", "path"};
    public static final String[] PATH_ATTRIBUTES = new String[]{"path"};
    public static final String[] HOST_ATTRIBUTES = new String[]{"host"};
    public static final String[] SOCKET_ATTRIBUTES = new String[]{"host", "port"};
    public static final String[] USERHOST_ATTRIBUTES = new String[]{"user", "host"};
    public static final String[] ALL_TRANSPORT_ATTRIBUTES = new String[]{"user", "password", "host", "port", "path"};
    private String address;
    private String meta;
    private String protocol;
    private String user;
    private String password;
    private String host;
    private String port;
    private String path;
    private Map queryMap;
    private MuleContext muleContext;
    private AtomicReference<EndpointURI> cache = new AtomicReference();

    public URIBuilder() {
    }

    public URIBuilder(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public URIBuilder(EndpointURI endpointURI) {
        this(endpointURI.getMuleContext());
        this.cache.set(endpointURI);
    }

    public URIBuilder(String address, MuleContext muleContext) {
        this(muleContext);
        int dots = address.indexOf(DOTS);
        int dotsSlashes = address.indexOf(DOTS_SLASHES);
        if (dots > -1 && dots < dotsSlashes) {
            this.meta = address.substring(0, dots);
            address = address.substring(dots + 1);
        }
        this.address = address;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setUser(String user) {
        this.assertNotUsed();
        this.user = user;
    }

    public void setPassword(String password) {
        this.assertNotUsed();
        this.password = password;
    }

    public void setHost(String host) {
        this.assertNotUsed();
        this.host = host;
    }

    public void setAddress(String address) {
        this.assertNotUsed();
        this.address = address;
        this.assertAddressConsistent();
    }

    public void setPort(int port) {
        this.assertNotUsed();
        this.port = Integer.toString(port);
    }

    public void setPort(String port) {
        this.assertNotUsed();
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.assertNotUsed();
        this.protocol = protocol;
        this.assertAddressConsistent();
    }

    public void setMeta(String meta) {
        this.assertNotUsed();
        this.meta = meta;
    }

    public void setPath(String path) {
        this.assertNotUsed();
        if (null != path) {
            if (path.indexOf(DOTS_SLASHES) > -1) {
                throw new IllegalArgumentException("Unusual syntax in path: '" + path + "' contains " + DOTS_SLASHES);
            }
            if (path.contains(BACKSLASH)) {
                try {
                    URI pathUri = new File(path).toURI();
                    path = pathUri.getPath();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Illegal syntax in path: " + path, ex);
                }
            }
        }
        this.path = path;
    }

    public void setQueryMap(Map queryMap) {
        this.assertNotUsed();
        this.queryMap = queryMap;
    }

    public EndpointURI getEndpoint() {
        if (null == this.cache.get()) {
            try {
                MuleEndpointURI endpointUri = new MuleEndpointURI(this.getConstructor(), this.getEncodedConstructor(), this.muleContext);
                this.cache.compareAndSet(null, endpointUri);
            }
            catch (EndpointException e) {
                throw (IllegalStateException)new IllegalStateException("Bad endpoint configuration").initCause(e);
            }
        }
        return this.cache.get();
    }

    protected String getConstructor() {
        return URLDecoder.decode(this.getEncodedConstructor());
    }

    protected String getEncodedConstructor() {
        StringBuilder buffer = new StringBuilder();
        this.appendMeta(buffer);
        OrderedQueryParameters uriQueries = this.appendAddress(buffer);
        uriQueries.override(this.queryMap);
        buffer.append(uriQueries.toString());
        this.removeRootTrailingSlash(buffer);
        return buffer.toString();
    }

    private void appendMeta(StringBuilder buffer) {
        if (null != this.meta) {
            buffer.append(this.meta);
            buffer.append(DOTS);
        }
    }

    private OrderedQueryParameters appendAddress(StringBuilder buffer) {
        if (null != this.address) {
            int index = this.address.indexOf(QUERY);
            if (index > -1) {
                buffer.append(this.address.substring(0, index));
                return this.parseQueries(this.address.substring(index + 1));
            }
            buffer.append(this.address);
            return new OrderedQueryParameters();
        }
        this.constructAddress(buffer);
        return new OrderedQueryParameters();
    }

    private OrderedQueryParameters parseQueries(String queries) {
        OrderedQueryParameters map = new OrderedQueryParameters();
        StringTokenizer query = new StringTokenizer(queries, AND);
        while (query.hasMoreTokens()) {
            StringTokenizer nameValue = new StringTokenizer(query.nextToken(), EQUALS);
            String name = nameValue.nextToken();
            String value = null;
            if (nameValue.hasMoreTokens()) {
                value = nameValue.nextToken();
            }
            map.put(name, value);
        }
        return map;
    }

    private void constructAddress(StringBuilder buffer) {
        buffer.append(this.protocol);
        buffer.append(DOTS_SLASHES);
        boolean atStart = true;
        if (null != this.user) {
            buffer.append(this.user);
            if (null != this.password) {
                buffer.append(DOTS);
                buffer.append(this.password);
            }
            buffer.append("@");
            atStart = false;
        }
        if (null != this.host) {
            buffer.append(this.host);
            if (null != this.port) {
                buffer.append(DOTS);
                buffer.append(this.port);
            }
            atStart = false;
        }
        if (null != this.path) {
            if (!atStart && !this.path.startsWith(SLASH)) {
                buffer.append(SLASH);
            }
            buffer.append(this.path);
        }
    }

    private void removeRootTrailingSlash(StringBuilder buffer) {
        int lastIndex = buffer.length() - 1;
        if (lastIndex >= 0 && buffer.charAt(lastIndex) == SLASH.charAt(0)) {
            int start = 0;
            int index = buffer.indexOf(DOTS_SLASHES);
            if (index != -1) {
                start = index + DOTS_SLASHES.length();
            }
            if (buffer.indexOf(SLASH, start) == lastIndex) {
                buffer.deleteCharAt(lastIndex);
            }
        }
    }

    protected void assertNotUsed() {
        if (null != this.cache.get()) {
            throw new IllegalStateException("Too late to set values - builder already used");
        }
    }

    protected void assertAddressConsistent() {
        if (null != this.meta) {
            if (null != this.address) {
                if (this.address.startsWith(this.meta + DOTS)) {
                    throw new IllegalArgumentException("Meta-protocol '" + this.meta + "' should not be specified in the address '" + this.address + "' - it is implicit in the element namespace.");
                }
                if (null != this.protocol) {
                    this.assertProtocolConsistent();
                } else if (this.address.indexOf(DOTS_SLASHES) == -1) {
                    throw new IllegalArgumentException("Address '" + this.address + "' does not have a transport protocol prefix " + "(omit the meta protocol prefix, '" + this.meta + DOTS + "' - it is implicit in the element namespace).");
                }
            }
        } else {
            this.assertProtocolConsistent();
        }
    }

    protected void assertProtocolConsistent() {
        if (null != this.protocol && null != this.address && !this.address.startsWith(this.protocol + DOTS_SLASHES)) {
            throw new IllegalArgumentException("Address '" + this.address + "' for protocol '" + this.protocol + "' should start with " + this.protocol + DOTS_SLASHES);
        }
    }

    public String toString() {
        return this.getConstructor();
    }

    public boolean equals(Object other) {
        if (null == other || !this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this == other) {
            return true;
        }
        URIBuilder builder = (URIBuilder)other;
        return URIBuilder.equal(this.address, builder.address) && URIBuilder.equal(this.meta, builder.meta) && URIBuilder.equal(this.protocol, builder.protocol) && URIBuilder.equal(this.user, builder.user) && URIBuilder.equal(this.password, builder.password) && URIBuilder.equal(this.host, builder.host) && URIBuilder.equal(this.port, builder.port) && URIBuilder.equal(this.path, builder.path) && URIBuilder.equal(this.queryMap, builder.queryMap);
    }

    protected static boolean equal(Object a, Object b) {
        return ClassUtils.equal(a, b);
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.address, this.meta, this.protocol, this.user, this.password, this.host, this.port, this.path, this.queryMap});
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getMeta() {
        return this.meta;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getAddress() {
        return this.address;
    }

    public Map getQueryMap() {
        return this.queryMap;
    }

    private static class OrderedQueryParameters {
        private List<String> names = new ArrayList<String>();
        private List<String> values = new ArrayList<String>();

        private OrderedQueryParameters() {
        }

        public void put(String name, String value) {
            this.names.add(name);
            this.values.add(value);
        }

        public void override(Map map) {
            if (null != map) {
                for (String name : new TreeMap(map).keySet()) {
                    String value = (String)map.get(name);
                    int pos = this.names.indexOf(name);
                    if (pos >= 0) {
                        this.values.set(pos, value);
                        continue;
                    }
                    this.names.add(name);
                    this.values.add(value);
                }
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            boolean first = true;
            for (int i = 0; i < this.names.size(); ++i) {
                if (first) {
                    buffer.append(URIBuilder.QUERY);
                    first = false;
                } else {
                    buffer.append(URIBuilder.AND);
                }
                buffer.append(this.names.get(i));
                String value = this.values.get(i);
                if (null == value) continue;
                buffer.append(URIBuilder.EQUALS);
                buffer.append(value);
            }
            return buffer.toString();
        }
    }
}

