/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transport.ExceptionHandlingReplyToHandlerDecorator;
import org.mule.api.transport.ReplyToHandler;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.NotificationHelper;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.execution.AsyncResponseFlowProcessingPhaseTemplate;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.PhaseResultNotifier;
import org.mule.execution.ResponseCompletionCallback;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.execution.ValidationPhase;
import org.mule.transaction.MuleTransactionConfig;

public class AsyncResponseFlowProcessingPhase
implements MessageProcessPhase<AsyncResponseFlowProcessingPhaseTemplate>,
Comparable<MessageProcessPhase> {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private ConcurrentHashMap<ServerNotificationManager, NotificationHelper> notificationHelpers = new ConcurrentHashMap();

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof AsyncResponseFlowProcessingPhaseTemplate;
    }

    @Override
    public void runPhase(final AsyncResponseFlowProcessingPhaseTemplate template, final MessageProcessContext messageProcessContext, final PhaseResultNotifier phaseResultNotifier) {
        try {
            try {
                final MessagingExceptionHandler exceptionHandler = messageProcessContext.getFlowConstruct().getExceptionListener();
                TransactionalErrorHandlingExecutionTemplate transactionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(messageProcessContext.getFlowConstruct().getMuleContext(), messageProcessContext.getTransactionConfig() == null ? new MuleTransactionConfig() : messageProcessContext.getTransactionConfig(), exceptionHandler);
                Object response = transactionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                    @Override
                    public MuleEvent process() throws Exception {
                        MuleEvent muleEvent = template.getMuleEvent();
                        AsyncResponseFlowProcessingPhase.this.fireNotification(muleEvent, 801);
                        if (muleEvent.isAllowNonBlocking()) {
                            muleEvent = new DefaultMuleEvent(muleEvent, new ExceptionHandlingReplyToHandlerDecorator(new FlowProcessingNonBlockingReplyToHandler(template, phaseResultNotifier, exceptionHandler), messageProcessContext.getFlowConstruct().getExceptionListener()));
                            OptimizedRequestContext.unsafeSetEvent(muleEvent);
                        }
                        return template.routeEvent(muleEvent);
                    }
                });
                if (response != NonBlockingVoidMuleEvent.getInstance()) {
                    this.fireNotification((MuleEvent)response, 805);
                    template.sendResponseToClient((MuleEvent)response, this.createResponseCompletationCallback(phaseResultNotifier, exceptionHandler));
                }
            }
            catch (MessagingException e) {
                template.sendFailureResponseToClient(e, this.createSendFailureResponseCompletationCallback(phaseResultNotifier));
            }
        }
        catch (Exception e) {
            phaseResultNotifier.phaseFailure(e);
        }
    }

    private void fireNotification(MuleEvent event, int action) {
        try {
            if (event == null && (event = RequestContext.getEvent()) == null) {
                return;
            }
            this.getNotificationHelper(event.getMuleContext().getNotificationManager()).fireNotification(event.getMessage(), event.getMessageSourceURI().toString(), event.getFlowConstruct(), action);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Could not fire notification. Action: " + action), (Throwable)e);
        }
    }

    private NotificationHelper getNotificationHelper(ServerNotificationManager serverNotificationManager) {
        NotificationHelper notificationHelper = this.notificationHelpers.get(serverNotificationManager);
        if (notificationHelper == null) {
            notificationHelper = new NotificationHelper(serverNotificationManager, ConnectorMessageNotification.class, false);
            this.notificationHelpers.putIfAbsent(serverNotificationManager, notificationHelper);
        }
        return notificationHelper;
    }

    private ResponseCompletionCallback createSendFailureResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public void responseSentWithFailure(Exception e, MuleEvent event) {
                phaseResultNotifier.phaseFailure(e);
            }
        };
    }

    private ResponseCompletionCallback createResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier, final MessagingExceptionHandler exceptionListener) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public void responseSentWithFailure(final Exception e, final MuleEvent event) {
                AsyncResponseFlowProcessingPhase.this.executeCallback(new Callback(){

                    @Override
                    public void execute() throws Exception {
                        ((DefaultMuleEvent)event).resetAccessControl();
                        exceptionListener.handleException(e, event);
                        phaseResultNotifier.phaseSuccessfully();
                    }
                }, phaseResultNotifier);
            }
        };
    }

    private void executeCallback(Callback callback, PhaseResultNotifier phaseResultNotifier) {
        try {
            callback.execute();
        }
        catch (Exception callbackException) {
            phaseResultNotifier.phaseFailure(callbackException);
        }
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }

    class FlowProcessingNonBlockingReplyToHandler
    implements ReplyToHandler {
        private final AsyncResponseFlowProcessingPhaseTemplate template;
        private final PhaseResultNotifier phaseResultNotifier;
        private final MessagingExceptionHandler exceptionHandler;

        public FlowProcessingNonBlockingReplyToHandler(AsyncResponseFlowProcessingPhaseTemplate template, PhaseResultNotifier phaseResultNotifier, MessagingExceptionHandler exceptionHandler) {
            this.template = template;
            this.phaseResultNotifier = phaseResultNotifier;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
            AsyncResponseFlowProcessingPhase.this.fireNotification(event, 805);
            this.template.sendResponseToClient(event, AsyncResponseFlowProcessingPhase.this.createResponseCompletationCallback(this.phaseResultNotifier, this.exceptionHandler));
        }

        @Override
        public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
            try {
                this.template.sendFailureResponseToClient(exception, AsyncResponseFlowProcessingPhase.this.createSendFailureResponseCompletationCallback(this.phaseResultNotifier));
            }
            catch (MuleException e) {
                this.phaseResultNotifier.phaseFailure(e);
            }
        }
    }

    private static interface Callback {
        public void execute() throws Exception;
    }
}

