/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.api.MuleContext;
import org.mule.config.spring.MuleArtifactContext;
import org.mule.extension.ExtensionManager;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.DataQualifierVisitor;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.module.extension.internal.config.ConfigurationBeanDefinitionParser;
import org.mule.module.extension.internal.config.OperationBeanDefinitionParser;
import org.mule.module.extension.internal.config.TopLevelParameterTypeBeanDefinitionParser;
import org.mule.module.extension.internal.introspection.BaseDataQualifierVisitor;
import org.mule.module.extension.internal.util.NameUtils;
import org.mule.util.ArrayUtils;
import org.mule.util.Preconditions;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ExtensionsNamespaceHandler
extends NamespaceHandlerSupport {
    private ExtensionManager extensionManager;
    private final Map<String, Extension> handledExtensions = new HashMap<String, Extension>();
    private final Multimap<Extension, String> topLevelParameters = HashMultimap.create();

    public void init() {
        this.extensionManager = ((MuleContext)MuleArtifactContext.getCurrentMuleContext().get()).getExtensionManager();
        Preconditions.checkState((this.extensionManager != null ? 1 : 0) != 0, (String)"Could not obtain handledExtensions manager");
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String namespace = element.getNamespaceURI();
        if (!this.isHandled(namespace)) {
            this.registerExtensionParsers(namespace, element, parserContext);
        }
        return super.parse(element, parserContext);
    }

    private boolean isHandled(String namespace) {
        return this.handledExtensions.containsKey(namespace);
    }

    private void registerExtensionParsers(String namespace, Element element, ParserContext parserContext) {
        try {
            Extension extension = this.locateExtensionByNamespace(namespace);
            this.registerTopLevelParameters(extension);
            this.registerConfigurations(extension);
            this.registerOperations(extension);
            this.handledExtensions.put(namespace, extension);
        }
        catch (Exception e) {
            parserContext.getReaderContext().fatal(e.getMessage(), (Object)element, (Throwable)e);
        }
    }

    private void registerOperations(Extension extension) throws Exception {
        for (Operation operation : extension.getOperations()) {
            this.registerBeanDefinitionParser(NameUtils.hyphenize((String)operation.getName()), new OperationBeanDefinitionParser(operation));
        }
    }

    private void registerConfigurations(Extension extension) throws Exception {
        for (Configuration configuration : extension.getConfigurations()) {
            this.registerBeanDefinitionParser(configuration.getName(), new ConfigurationBeanDefinitionParser(configuration));
        }
    }

    private void registerTopLevelParameters(Extension extension) {
        for (Configuration configuration : extension.getConfigurations()) {
            this.registerTopLevelParameter(extension, configuration.getParameters());
        }
        for (Operation operation : extension.getOperations()) {
            this.registerTopLevelParameter(extension, operation.getParameters());
        }
    }

    private void registerTopLevelParameter(final Extension extension, final DataType parameterType) {
        parameterType.getQualifier().accept((DataQualifierVisitor)new BaseDataQualifierVisitor(){

            public void onPojo() {
                String name = NameUtils.hyphenize((String)NameUtils.getGlobalPojoTypeName((DataType)parameterType));
                if (ExtensionsNamespaceHandler.this.topLevelParameters.put((Object)extension, (Object)name)) {
                    ExtensionsNamespaceHandler.this.registerBeanDefinitionParser(name, new TopLevelParameterTypeBeanDefinitionParser(parameterType));
                }
            }

            public void onList() {
                if (!ArrayUtils.isEmpty((Object[])parameterType.getGenericTypes())) {
                    ExtensionsNamespaceHandler.this.registerTopLevelParameter(extension, parameterType.getGenericTypes()[0]);
                }
            }

            public void onMap() {
                DataType[] genericTypes = parameterType.getGenericTypes();
                if (genericTypes == null) {
                    return;
                }
                if (genericTypes.length >= 1) {
                    DataType keyType = genericTypes[0];
                    ExtensionsNamespaceHandler.this.registerTopLevelParameter(extension, keyType);
                }
                if (genericTypes.length >= 2) {
                    DataType valueType = parameterType.getGenericTypes()[0];
                    valueType.getQualifier().accept((DataQualifierVisitor)this);
                    ExtensionsNamespaceHandler.this.registerTopLevelParameter(extension, valueType);
                }
            }
        });
    }

    private void registerTopLevelParameter(Extension extension, Collection<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            this.registerTopLevelParameter(extension, parameter.getType());
        }
    }

    private Extension locateExtensionByNamespace(String namespace) {
        Set capableExtensions = this.extensionManager.getExtensionsCapableOf(XmlCapability.class);
        if (CollectionUtils.isEmpty((Collection)capableExtensions)) {
            throw new IllegalArgumentException(String.format("Could not find any handled extensions supporting XML capabilities. Can't process namespace %s", namespace));
        }
        for (Extension extension : capableExtensions) {
            XmlCapability capability = (XmlCapability)extension.getCapabilities(XmlCapability.class).iterator().next();
            if (!namespace.equals(capability.getSchemaLocation())) continue;
            return extension;
        }
        throw new IllegalArgumentException(String.format("Could not find extension associated to namespace %s", namespace));
    }
}

