/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;

public class DefaultMuleMessageTestCase
extends AbstractMuleContextTestCase {
    public static final String FOO_PROPERTY = "foo";

    @Test
    public void testConstructorWithNoMuleContext() {
        try {
            new DefaultMuleMessage((Object)"Test Message", null);
            Assert.fail((String)"DefaultMuleMessage must fail when created with null MuleContext");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructorWithNullPayload() {
        DefaultMuleMessage message = new DefaultMuleMessage(null, muleContext);
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)message.getPayload());
    }

    @Test
    public void testOneArgConstructor() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        Assert.assertEquals((Object)"Test Message", (Object)message.getPayload());
    }

    @Test
    public void testOneArgConstructorWithMuleMessageAsPayload() {
        MuleMessage oldMessage = this.createMuleMessage();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)oldMessage, muleContext);
        Assert.assertEquals((Object)"MULE_MESSAGE", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MuleMessage", (MuleMessage)message);
    }

    @Test
    public void testMessagePropertiesConstructor() {
        Map<String, Object> properties = this.createMessageProperties();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", properties, muleContext);
        Assert.assertEquals((Object)"Test Message", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MessageProperties", (MuleMessage)message);
    }

    @Test
    public void testMessagePropertiesAccessors() {
        Map<String, Object> properties = this.createMessageProperties();
        properties.put("number", "24");
        properties.put("decimal", "24.3");
        properties.put("boolean", "true");
        Apple apple = new Apple(true);
        properties.put("apple", apple);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", properties, muleContext);
        Assert.assertTrue((boolean)((Boolean)message.getOutboundProperty("boolean", (Object)false)));
        Assert.assertEquals((Object)new Integer(24), (Object)message.getOutboundProperty("number", (Object)0));
        Assert.assertEquals((Object)new Byte(24), (Object)message.getOutboundProperty("number", (Object)0));
        Assert.assertEquals((Object)new Long(24L), (Object)message.getOutboundProperty("number", (Object)0L));
        Assert.assertEquals((Object)new Float(24.3), (Object)message.getOutboundProperty("decimal", (Object)Float.valueOf(0.0f)));
        Double d = (Double)message.getOutboundProperty("decimal", (Object)0.0);
        Assert.assertEquals((Object)new Double(24.3), (Object)d);
        Assert.assertEquals((Object)"true", (Object)message.getOutboundProperty("boolean", (Object)""));
        Assert.assertEquals((Object)apple, (Object)message.getOutboundProperty("apple"));
        try {
            message.getOutboundProperty("apple", (Object)new Orange());
            Assert.fail((String)"Orange is not assignable to Apple");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertNull((Object)message.getOutboundProperty("banana"));
        Assert.assertNull((Object)message.getOutboundProperty("blah"));
        Assert.assertEquals((Object)new Float(24.3), (Object)message.getOutboundProperty("blah", (Object)Float.valueOf(24.3f)));
    }

    @Test
    public void testMessagePropertiesConstructorWithMuleMessageAsPayload() {
        Map<String, Object> properties = this.createMessageProperties();
        MuleMessage previousMessage = this.createMuleMessage();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)previousMessage, properties, muleContext);
        Assert.assertEquals((Object)"MULE_MESSAGE", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MessageProperties", (MuleMessage)message);
        this.assertOutboundMessageProperty("MuleMessage", (MuleMessage)message);
    }

    @Test
    public void testPreviousMessageConstructorWithRegularPayloadAndMuleMessageAsPrevious() {
        MuleMessage previous = this.createMuleMessage();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", previous, muleContext);
        Assert.assertEquals((Object)"Test Message", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MuleMessage", (MuleMessage)message);
        Assert.assertEquals((Object)previous.getUniqueId(), (Object)message.getUniqueId());
    }

    @Test
    public void testPreviousMessageConstructorWithMuleMessageAsPayloadAndMuleMessageAsPrevious() {
        MuleMessage payload = this.createMuleMessage();
        payload.setOutboundProperty("payload", (Object)"payload");
        MuleMessage previous = this.createMuleMessage();
        previous.setOutboundProperty("previous", (Object)"previous");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)payload, previous, muleContext);
        Assert.assertEquals((Object)"MULE_MESSAGE", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MuleMessage", (MuleMessage)message);
        this.assertOutboundMessageProperty("payload", (MuleMessage)message);
        Assert.assertEquals((Object)previous.getUniqueId(), (Object)message.getUniqueId());
    }

    @Test
    public void testClearProperties() {
        MuleMessage payload = this.createMuleMessage();
        payload.setOutboundProperty(FOO_PROPERTY, (Object)"fooValue");
        payload.setInvocationProperty("bar", (Object)"barValue");
        Assert.assertEquals((long)1L, (long)payload.getInvocationPropertyNames().size());
        Assert.assertEquals((long)2L, (long)payload.getOutboundPropertyNames().size());
        Assert.assertEquals((long)0L, (long)payload.getInboundPropertyNames().size());
        payload.clearProperties(PropertyScope.INVOCATION);
        Assert.assertEquals((long)0L, (long)payload.getInvocationPropertyNames().size());
        payload.clearProperties(PropertyScope.OUTBOUND);
        Assert.assertEquals((long)0L, (long)payload.getOutboundPropertyNames().size());
    }

    @Test
    public void testCopyConstructor() throws Exception {
        DefaultMuleMessage original = (DefaultMuleMessage)this.createMuleMessage();
        Map<String, Object> properties = this.createMessageProperties();
        original.addInboundProperties(properties);
        this.assertInboundAndOutboundMessageProperties((MuleMessage)original);
        DefaultMuleMessage copy = new DefaultMuleMessage((MuleMessage)original);
        this.assertInboundAndOutboundMessageProperties((MuleMessage)copy);
        Assert.assertEquals((Object)muleContext.getConfiguration().getDefaultEncoding(), (Object)copy.getEncoding());
        original.setProperty("FOO", (Object)"OTHER", PropertyScope.OUTBOUND);
        Assert.assertNull((Object)copy.getProperty("FOO", PropertyScope.OUTBOUND));
        original.setProperty("FOO", (Object)"OTHER", PropertyScope.INBOUND);
        Assert.assertNull((Object)copy.getProperty("FOO", PropertyScope.INBOUND));
        copy.setProperty("ABC", (Object)"OTHER", PropertyScope.OUTBOUND);
        Assert.assertNull((Object)original.getProperty("ABC", PropertyScope.OUTBOUND));
        copy.setProperty("ABC", (Object)"OTHER", PropertyScope.INBOUND);
        Assert.assertNull((Object)original.getProperty("ABC", PropertyScope.INBOUND));
    }

    private void assertInboundAndOutboundMessageProperties(MuleMessage original) {
        this.assertOutboundMessageProperty("MuleMessage", original);
        Assert.assertEquals((Object)"MessageProperties", (Object)original.getInboundProperty("MessageProperties"));
    }

    @Test
    public void testLegacyAddingAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DataHandler handler = new DataHandler((Object)"this is the attachment", "text/plain");
        message.addOutboundAttachment("attachment", handler);
        Assert.assertTrue((boolean)message.getOutboundAttachmentNames().contains("attachment"));
        Assert.assertEquals((Object)handler, (Object)message.getOutboundAttachment("attachment"));
    }

    @Test
    public void testAddingOutboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DataHandler handler = new DataHandler((Object)"this is the attachment", "text/plain");
        message.addOutboundAttachment("attachment", handler);
        Assert.assertTrue((boolean)message.getOutboundAttachmentNames().contains("attachment"));
        Assert.assertEquals((Object)handler, (Object)message.getOutboundAttachment("attachment"));
        Assert.assertEquals((long)0L, (long)message.getInboundAttachmentNames().size());
        message.removeOutboundAttachment("attachment");
        Assert.assertEquals((long)0L, (long)message.getOutboundAttachmentNames().size());
        message.addOutboundAttachment("spi-props", (Object)IOUtils.getResourceAsUrl((String)"test-spi.properties", this.getClass()), "text/plain");
        Assert.assertTrue((boolean)message.getOutboundAttachmentNames().contains("spi-props"));
        handler = message.getOutboundAttachment("spi-props");
        Assert.assertEquals((Object)"text/plain", (Object)handler.getContentType());
        Assert.assertEquals((long)1L, (long)message.getOutboundAttachmentNames().size());
        message.addOutboundAttachment("dummy", (Object)IOUtils.getResourceAsUrl((String)"dummy.xml", this.getClass()), null);
        handler = message.getOutboundAttachment("dummy");
        Assert.assertEquals((Object)"application/xml", (Object)handler.getContentType());
        Assert.assertEquals((long)2L, (long)message.getOutboundAttachmentNames().size());
    }

    @Test
    public void testAddingInboundAttachment() throws Exception {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        String attachmentData = "this is the attachment";
        DataHandler dh = new DataHandler((Object)attachmentData, "text/plain");
        attachments.put("attachment", dh);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", null, attachments, muleContext);
        Assert.assertTrue((boolean)message.getInboundAttachmentNames().contains("attachment"));
        Assert.assertEquals((Object)dh, (Object)message.getInboundAttachment("attachment"));
        Assert.assertEquals((long)0L, (long)message.getOutboundAttachmentNames().size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(message);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        MuleMessage message2 = (MuleMessage)ois.readObject();
        Assert.assertTrue((boolean)message2.getInboundAttachmentNames().contains("attachment"));
        Assert.assertEquals((Object)message2.getInboundAttachment("attachment").getContent(), (Object)attachmentData);
        Assert.assertEquals((long)0L, (long)message2.getOutboundAttachmentNames().size());
    }

    @Test
    public void testNewMuleMessageFromMuleMessageWithAttachment() throws Exception {
        MuleMessage previous = this.createMuleMessage();
        DataHandler handler = new DataHandler((Object)"this is the attachment", "text/plain");
        previous.addOutboundAttachment("attachment", handler);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", previous, muleContext);
        Assert.assertTrue((boolean)message.getOutboundAttachmentNames().contains("attachment"));
        Assert.assertEquals((Object)handler, (Object)message.getOutboundAttachment("attachment"));
    }

    @Test
    public void testFindPropertiesInAnyScope() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.removeProperty("MuleMessage", PropertyScope.OUTBOUND);
        RequestContext.setEvent((MuleEvent)new DefaultMuleEvent(message, DefaultMuleMessageTestCase.getTestInboundEndpoint(FOO_PROPERTY), (FlowConstruct)DefaultMuleMessageTestCase.getTestService()));
        message.setOutboundProperty(FOO_PROPERTY, (Object)"fooOutbound");
        message.setInvocationProperty("bar", (Object)"barInvocation");
        message.setInvocationProperty(FOO_PROPERTY, (Object)"fooInvocation");
        message.setProperty(FOO_PROPERTY, (Object)"fooInbound", PropertyScope.INBOUND);
        message.setSessionProperty(FOO_PROPERTY, (Object)"fooSession");
        Assert.assertEquals((long)2L, (long)message.getInvocationPropertyNames().size());
        Assert.assertEquals((long)1L, (long)message.getOutboundPropertyNames().size());
        Assert.assertEquals((long)1L, (long)message.getInboundPropertyNames().size());
        Assert.assertEquals((long)1L, (long)message.getSessionPropertyNames().size());
        String value = (String)message.findPropertyInAnyScope(FOO_PROPERTY, null);
        Assert.assertEquals((Object)"fooOutbound", (Object)value);
        message.removeProperty(FOO_PROPERTY, PropertyScope.OUTBOUND);
        value = (String)message.findPropertyInAnyScope(FOO_PROPERTY, null);
        Assert.assertEquals((Object)"fooInvocation", (Object)value);
        message.removeProperty(FOO_PROPERTY, PropertyScope.INVOCATION);
        value = (String)message.findPropertyInAnyScope(FOO_PROPERTY, null);
        Assert.assertEquals((Object)"fooSession", (Object)value);
        message.removeProperty(FOO_PROPERTY, PropertyScope.SESSION);
        value = (String)message.findPropertyInAnyScope(FOO_PROPERTY, null);
        Assert.assertEquals((Object)"fooInbound", (Object)value);
        value = (String)message.findPropertyInAnyScope("bar", null);
        Assert.assertEquals((Object)"barInvocation", (Object)value);
    }

    private Map<String, Object> createMessageProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MessageProperties", "MessageProperties");
        return map;
    }

    private MuleMessage createMuleMessage() {
        DefaultMuleMessage previousMessage = new DefaultMuleMessage((Object)"MULE_MESSAGE", muleContext);
        previousMessage.setOutboundProperty("MuleMessage", (Object)"MuleMessage");
        return previousMessage;
    }

    private void assertOutboundMessageProperty(String key, MuleMessage message) {
        Assert.assertEquals((Object)key, (Object)message.getOutboundProperty(key));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPropertyNamesImmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.getPropertyNames().add("other");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInboundPropertyNamesAddImmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.getPropertyNames(PropertyScope.INBOUND).add("other");
    }

    public void testInboundPropertyNamesRemoveMmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.setProperty(FOO_PROPERTY, (Object)"bar", PropertyScope.INBOUND);
        message.getPropertyNames(PropertyScope.INBOUND).remove(FOO_PROPERTY);
        Assert.assertNull((Object)message.getInboundProperty(FOO_PROPERTY));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOutboundPropertyNamesImmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.getPropertyNames(PropertyScope.OUTBOUND).add("other");
    }

    public void testOutboundPropertyNamesRemoveMmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.setOutboundProperty(FOO_PROPERTY, (Object)"bar");
        message.getPropertyNames(PropertyScope.OUTBOUND).remove(FOO_PROPERTY);
        Assert.assertNull((Object)message.getOutboundProperty(FOO_PROPERTY));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvocationPropertyNamesImmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.getPropertyNames(PropertyScope.INVOCATION).add("other");
    }

    public void tesInvocationPropertyNamesRemoveMmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.setInvocationProperty(FOO_PROPERTY, (Object)"bar");
        message.getPropertyNames(PropertyScope.INVOCATION).remove(FOO_PROPERTY);
        Assert.assertNull((Object)message.getInvocationProperty(FOO_PROPERTY));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSessionPropertyNamesImmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.getPropertyNames(PropertyScope.SESSION).add("other");
    }

    public void testtSessionPropertyNamesRemoveMmutable() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.setSessionProperty(FOO_PROPERTY, (Object)"bar");
        message.getPropertyNames(PropertyScope.SESSION).remove(FOO_PROPERTY);
        Assert.assertNull((Object)message.getSessionProperty(FOO_PROPERTY));
    }

    @Test
    public void usesNullPayloadAsNull() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.setProperty(FOO_PROPERTY, (Object)NullPayload.getInstance(), PropertyScope.OUTBOUND);
        MatcherAssert.assertThat((Object)message.getProperty(FOO_PROPERTY, PropertyScope.OUTBOUND), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

